/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive;

import com.c4_soft.springaddons.security.oidc.starter.properties.CorsProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.Csrf;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcClientProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcResourceServerProperties;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientAuthorizeExchangeSpecPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.client.ClientReactiveHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.ResourceServerAuthorizeExchangeSpecPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.reactive.resourceserver.ResourceServerReactiveHttpSecurityPostProcessor;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.csrf.CookieServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestHandler;
import org.springframework.security.web.server.csrf.XorServerCsrfTokenRequestAttributeHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactiveConfigurationSupport {
    public static ServerHttpSecurity configureResourceServer(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcResourceServerProperties addonsResourceServerProperties, ServerAuthenticationEntryPoint authenticationEntryPoint, Optional<ServerAccessDeniedHandler> accessDeniedHandler, ResourceServerAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ResourceServerReactiveHttpSecurityPostProcessor httpPostProcessor) {
        ReactiveConfigurationSupport.configureCors(http, addonsResourceServerProperties.getCors());
        ReactiveConfigurationSupport.configureState(http, addonsResourceServerProperties.isStatlessSessions(), addonsResourceServerProperties.getCsrf());
        ReactiveConfigurationSupport.configureAccess(http, addonsResourceServerProperties.getPermitAll(), addonsResourceServerProperties.getCors());
        http.exceptionHandling(handling -> {
            handling.authenticationEntryPoint(authenticationEntryPoint);
            accessDeniedHandler.ifPresent(arg_0 -> ((ServerHttpSecurity.ExceptionHandlingSpec)handling).accessDeniedHandler(arg_0));
        });
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.redirectToHttps(Customizer.withDefaults());
        }
        http.authorizeExchange(registry -> authorizePostProcessor.authorizeHttpRequests((ServerHttpSecurity.AuthorizeExchangeSpec)registry));
        httpPostProcessor.process(http);
        return http;
    }

    public static ServerHttpSecurity configureClient(ServerHttpSecurity http, ServerProperties serverProperties, SpringAddonsOidcClientProperties addonsClientProperties, ClientAuthorizeExchangeSpecPostProcessor authorizePostProcessor, ClientReactiveHttpSecurityPostProcessor httpPostProcessor) {
        ReactiveConfigurationSupport.configureCors(http, addonsClientProperties.getCors());
        ReactiveConfigurationSupport.configureState(http, false, addonsClientProperties.getCsrf());
        ReactiveConfigurationSupport.configureAccess(http, addonsClientProperties.getPermitAll(), addonsClientProperties.getCors());
        if (serverProperties.getSsl() != null && serverProperties.getSsl().isEnabled()) {
            http.redirectToHttps(Customizer.withDefaults());
        }
        http.authorizeExchange(registry -> authorizePostProcessor.authorizeHttpRequests((ServerHttpSecurity.AuthorizeExchangeSpec)registry));
        httpPostProcessor.process(http);
        return http;
    }

    public static ServerHttpSecurity configureAccess(ServerHttpSecurity http, List<String> permitAll, List<CorsProperties> corsProperties) {
        List<String> permittedCorsOptions = corsProperties.stream().filter(cors -> (cors.getAllowedMethods().contains("*") || cors.getAllowedMethods().contains("OPTIONS")) && !cors.isDisableAnonymousOptions()).map(CorsProperties::getPath).toList();
        if (permitAll.size() > 0 || permittedCorsOptions.size() > 0) {
            http.anonymous(Customizer.withDefaults());
        }
        if (permitAll.size() > 0) {
            http.authorizeExchange(authorizeExchange -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchange.pathMatchers(permitAll.toArray(new String[0]))).permitAll());
        }
        if (permittedCorsOptions.size() > 0) {
            http.authorizeExchange(authorizeExchange -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchange.pathMatchers(HttpMethod.OPTIONS, permittedCorsOptions.toArray(new String[0]))).permitAll());
        }
        return http;
    }

    public static ServerHttpSecurity configureCors(ServerHttpSecurity http, List<CorsProperties> corsProperties) {
        if (corsProperties.size() == 0) {
            http.cors(cors -> cors.disable());
        } else {
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
            for (CorsProperties corsProps : corsProperties) {
                CorsConfiguration configuration = new CorsConfiguration();
                configuration.setAllowCredentials(corsProps.getAllowCredentials());
                configuration.setAllowedHeaders(corsProps.getAllowedHeaders());
                configuration.setAllowedMethods(corsProps.getAllowedMethods());
                configuration.setAllowedOriginPatterns(corsProps.getAllowedOriginPatterns());
                configuration.setExposedHeaders(corsProps.getExposedHeaders());
                configuration.setMaxAge(corsProps.getMaxAge());
                source.registerCorsConfiguration(corsProps.getPath(), configuration);
            }
            http.cors(cors -> cors.configurationSource((CorsConfigurationSource)source));
        }
        return http;
    }

    public static ServerHttpSecurity configureState(ServerHttpSecurity http, boolean isStatless, Csrf csrfEnum) {
        if (isStatless) {
            http.securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
        }
        http.csrf(csrf -> {
            switch (csrfEnum) {
                case DISABLE: {
                    csrf.disable();
                    break;
                }
                case DEFAULT: {
                    if (isStatless) {
                        csrf.disable();
                        break;
                    }
                    Customizer.withDefaults();
                    break;
                }
                case SESSION: {
                    Customizer.withDefaults();
                    break;
                }
                case COOKIE_ACCESSIBLE_FROM_JS: {
                    csrf.csrfTokenRepository((ServerCsrfTokenRepository)CookieServerCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((ServerCsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler());
                }
            }
        });
        return http;
    }

    static final class SpaCsrfTokenRequestHandler
    extends ServerCsrfTokenRequestAttributeHandler {
        private final ServerCsrfTokenRequestAttributeHandler delegate = new XorServerCsrfTokenRequestAttributeHandler();

        SpaCsrfTokenRequestHandler() {
        }

        public void handle(ServerWebExchange exchange, Mono<CsrfToken> csrfToken) {
            this.delegate.handle(exchange, csrfToken);
        }

        public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange, CsrfToken csrfToken) {
            boolean hasHeader = Optional.ofNullable(exchange.getRequest().getHeaders().get((Object)csrfToken.getHeaderName())).orElse(List.of()).stream().filter(StringUtils::hasText).count() > 0L;
            return hasHeader ? super.resolveCsrfTokenValue(exchange, csrfToken) : this.delegate.resolveCsrfTokenValue(exchange, csrfToken);
        }
    }
}

