/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.test.annotations.DoubleClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IntClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.LongClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringClaim;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface NestedClaims {
    public String name();

    public IntClaim[] intClaims() default {};

    public LongClaim[] longClaims() default {};

    public DoubleClaim[] doubleClaims() default {};

    public StringClaim[] stringClaims() default {};

    public StringClaim[] uriClaims() default {};

    public StringClaim[] urlClaims() default {};

    public IntClaim[] epochSecondClaims() default {};

    public StringClaim[] dateClaims() default {};

    public StringArrayClaim[] stringArrayClaims() default {};

    public JsonObjectClaim[] jsonObjectClaims() default {};

    public JsonObjectArrayClaim[] jsonObjectArrayClaims() default {};

    public static class Support {
        private static final SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

        private Support() {
        }

        public static Map<String, Object> parse(NestedClaims annotation) throws MalformedURLException, ParseException {
            HashMap<String, Object> claims = new HashMap<String, Object>();
            for (IntClaim intClaim : annotation.intClaims()) {
                claims.put(intClaim.name(), intClaim.value());
            }
            for (Annotation annotation2 : annotation.longClaims()) {
                claims.put(annotation2.name(), annotation2.value());
            }
            for (Annotation annotation3 : annotation.doubleClaims()) {
                claims.put(annotation3.name(), annotation3.value());
            }
            for (Annotation annotation4 : annotation.stringClaims()) {
                claims.put(annotation4.name(), annotation4.value());
            }
            for (Annotation annotation5 : annotation.uriClaims()) {
                claims.put(annotation5.name(), URI.create(annotation5.value()));
            }
            for (Annotation annotation6 : annotation.urlClaims()) {
                claims.put(annotation6.name(), new URL(annotation6.value()));
            }
            for (Annotation annotation7 : annotation.epochSecondClaims()) {
                claims.put(annotation7.name(), new Date(1000L * (long)annotation7.value()));
            }
            for (Annotation annotation8 : annotation.dateClaims()) {
                claims.put(annotation8.name(), isoFormat.parse(annotation8.value()));
            }
            for (Annotation annotation9 : annotation.stringArrayClaims()) {
                claims.put(annotation9.name(), annotation9.value());
            }
            for (Annotation annotation10 : annotation.jsonObjectClaims()) {
                claims.put(annotation10.name(), JsonObjectClaim.Support.parse((JsonObjectClaim)annotation10));
            }
            for (Annotation annotation11 : annotation.jsonObjectArrayClaims()) {
                claims.put(annotation11.name(), JsonObjectArrayClaim.Support.parse((JsonObjectArrayClaim)annotation11));
            }
            return Collections.unmodifiableMap(claims);
        }
    }
}

