/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.test.annotations;

import com.c4_soft.springaddons.security.oauth2.ModifiableClaimSet;
import com.c4_soft.springaddons.security.oauth2.test.annotations.DoubleClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.IntClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.JsonObjectClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.LongClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.NestedClaims;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringArrayClaim;
import com.c4_soft.springaddons.security.oauth2.test.annotations.StringClaim;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Claims {
    public IntClaim[] intClaims() default {};

    public LongClaim[] longClaims() default {};

    public DoubleClaim[] doubleClaims() default {};

    public StringClaim[] stringClaims() default {};

    public StringClaim[] uriClaims() default {};

    public StringClaim[] urlClaims() default {};

    public IntClaim[] epochSecondClaims() default {};

    public StringClaim[] dateClaims() default {};

    public StringArrayClaim[] stringArrayClaims() default {};

    public NestedClaims[] nestedClaims() default {};

    public JsonObjectClaim[] jsonObjectClaims() default {};

    public JsonObjectArrayClaim[] jsonObjectArrayClaims() default {};

    public static class Token {
        private static final SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

        private Token() {
        }

        public static ModifiableClaimSet of(Claims annotation) {
            ModifiableClaimSet claims = new ModifiableClaimSet();
            try {
                for (IntClaim intClaim : annotation.intClaims()) {
                    claims.claim(intClaim.name(), (Object)intClaim.value());
                }
                for (Annotation annotation2 : annotation.longClaims()) {
                    claims.claim(annotation2.name(), (Object)annotation2.value());
                }
                for (Annotation annotation3 : annotation.doubleClaims()) {
                    claims.claim(annotation3.name(), (Object)annotation3.value());
                }
                for (Annotation annotation4 : annotation.stringClaims()) {
                    claims.claim(annotation4.name(), annotation4.value());
                }
                for (Annotation annotation5 : annotation.uriClaims()) {
                    claims.claim(annotation5.name(), (Object)URI.create(annotation5.value()));
                }
                for (Annotation annotation6 : annotation.urlClaims()) {
                    claims.claim(annotation6.name(), (Object)new URL(annotation6.value()));
                }
                for (Annotation annotation7 : annotation.epochSecondClaims()) {
                    claims.claim(annotation7.name(), (Object)new Date(1000L * (long)annotation7.value()));
                }
                for (Annotation annotation8 : annotation.dateClaims()) {
                    claims.claim(annotation8.name(), (Object)isoFormat.parse(annotation8.value()));
                }
                for (Annotation annotation9 : annotation.stringArrayClaims()) {
                    claims.claim(annotation9.name(), (Object)annotation9.value());
                }
                for (Annotation annotation10 : annotation.nestedClaims()) {
                    claims.claim(annotation10.name(), NestedClaims.Support.parse((NestedClaims)annotation10));
                }
                for (Annotation annotation11 : annotation.jsonObjectClaims()) {
                    claims.claim(annotation11.name(), JsonObjectClaim.Support.parse((JsonObjectClaim)annotation11));
                }
                for (Annotation annotation12 : annotation.jsonObjectArrayClaims()) {
                    claims.claim(annotation12.name(), JsonObjectArrayClaim.Support.parse((JsonObjectArrayClaim)annotation12));
                }
            }
            catch (MalformedURLException | ParseException e) {
                throw new MalformedTestClaimAnotation(e);
            }
            return claims;
        }

        static class MalformedTestClaimAnotation
        extends RuntimeException {
            public MalformedTestClaimAnotation(Throwable e) {
                super(e);
            }
        }
    }
}

