/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.oauth2.rfc7662;

import com.c4_soft.oauth2.ModifiableClaimSet;
import com.c4_soft.oauth2.UnmodifiableClaimSet;
import com.c4_soft.oauth2.rfc6749.TokenType;
import com.c4_soft.oauth2.rfc7662.IntrospectionClaimNames;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IntrospectionClaimSet
extends UnmodifiableClaimSet
implements Principal {
    public IntrospectionClaimSet(Map<String, Object> claims) {
        super(claims);
    }

    @Override
    public String getName() {
        return this.getUsername();
    }

    public Boolean getActive() {
        return this.getAsBoolean(IntrospectionClaimNames.ACTIVE.value);
    }

    public Collection<String> getAudience() {
        return this.getAsStringSet(IntrospectionClaimNames.AUDIENCE.value);
    }

    public String getClientId() {
        return this.getAsString(IntrospectionClaimNames.CLIENT_ID.value);
    }

    public Instant getExpiresAt() {
        return this.getAsInstant(IntrospectionClaimNames.EXPIRES_AT.value);
    }

    public Instant getIssuedAt() {
        return this.getAsInstant(IntrospectionClaimNames.ISSUED_AT.value);
    }

    public URI getIssuer() throws URISyntaxException {
        return this.getAsUri(IntrospectionClaimNames.ISSUER.value);
    }

    public String getJti() {
        return this.getAsString(IntrospectionClaimNames.JTI.value);
    }

    public Instant getNotBefore() {
        return this.getAsInstant(IntrospectionClaimNames.NOT_BEFORE.value);
    }

    public Set<String> getScope() {
        Set<String> claim = this.getAsStringSet(IntrospectionClaimNames.SCOPE.value);
        return claim == null ? Collections.emptySet() : claim;
    }

    public String getSubject() {
        return this.getAsString(IntrospectionClaimNames.SUBJECT.value);
    }

    public TokenType getTokenType() {
        String str = this.getAsString(IntrospectionClaimNames.TOKEN_TYPE.value);
        if (str == null) {
            return null;
        }
        return TokenType.valueOf(str);
    }

    public String getUsername() {
        return this.getAsString(IntrospectionClaimNames.USERNAME.value);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>>
    extends ModifiableClaimSet {
        private static final long serialVersionUID = -6994538451749533929L;

        public T active(Boolean active) {
            this.claim(IntrospectionClaimNames.ACTIVE.value, active);
            return this.downcast();
        }

        public T audience(Stream<String> audience) {
            this.claim(IntrospectionClaimNames.AUDIENCE.value, audience.collect(Collectors.toSet()));
            return this.downcast();
        }

        public T audience(String ... audience) {
            return this.audience(Stream.of(audience));
        }

        public T audience(Collection<String> audience) {
            return this.audience(audience.stream());
        }

        public T clientId(String clientId) {
            this.claim(IntrospectionClaimNames.CLIENT_ID.value, clientId);
            return this.downcast();
        }

        public T expirationTime(Instant expirationTime) {
            this.claim(IntrospectionClaimNames.EXPIRES_AT.value, expirationTime);
            return this.downcast();
        }

        public T expiresIn(long seconds) {
            this.claim(IntrospectionClaimNames.EXPIRES_AT.value, Instant.now().plus(Duration.ofSeconds(seconds)));
            return this.downcast();
        }

        public T issuedAt(Instant issuedAt) {
            this.claim(IntrospectionClaimNames.ISSUED_AT.value, issuedAt);
            return this.downcast();
        }

        public T issuer(String issuer) {
            this.claim(IntrospectionClaimNames.ISSUER.value, issuer);
            return this.downcast();
        }

        public T jwtId(String jwtId) {
            this.claim(IntrospectionClaimNames.JTI.value, jwtId);
            return this.downcast();
        }

        public T notBefore(Instant notBefore) {
            this.claim(IntrospectionClaimNames.NOT_BEFORE.value, notBefore);
            return this.downcast();
        }

        public T scopes(Stream<String> scope) {
            this.claim(IntrospectionClaimNames.SCOPE.value, scope.collect(Collectors.toSet()));
            return this.downcast();
        }

        public T scopes(String ... scope) {
            return this.scopes(Stream.of(scope));
        }

        public T scopes(Collection<String> scope) {
            return this.scopes(scope.stream());
        }

        public T scope(String scope) {
            Set<String> currentScopes = this.getAsStringSet(IntrospectionClaimNames.SCOPE.value);
            if (currentScopes == null) {
                return this.scopes(scope);
            }
            return this.scopes(Stream.concat(currentScopes.stream(), Stream.of(scope)));
        }

        public T subject(String subject) {
            this.claim(IntrospectionClaimNames.SUBJECT.value, subject);
            return this.downcast();
        }

        public T tokenType(TokenType tokenType) {
            this.claim(IntrospectionClaimNames.TOKEN_TYPE.value, tokenType.value);
            return this.downcast();
        }

        public T username(String username) {
            this.claim(IntrospectionClaimNames.USERNAME.value, username);
            return this.downcast();
        }

        public IntrospectionClaimSet build() {
            return this.build(this);
        }

        public IntrospectionClaimSet build(Map<String, Object> claims) {
            return new IntrospectionClaimSet(claims);
        }

        protected T downcast() {
            return (T)this;
        }
    }
}

