/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttffmpeg;

import android.util.Log;
import com.ss.ttffmpeg.CustomVerify;
import com.ss.ttffmpeg.IFFmpegLoader;
import com.ss.ttffmpeg.IVerifyLoader;
import java.util.ArrayList;
import java.util.List;

public final class FFmpegLibLoaderWrapper {
    private static volatile boolean sHasLoadFFmpeg = false;
    private static volatile IFFmpegLoader sIFFmpegLoader = null;
    private static volatile IVerifyLoader sIFFmpegVerifyLoader = null;
    private static final String TAG = "FFmpegLibLoaderWrapper";
    private static boolean isVcnverifyload = false;

    public static synchronized boolean loadFFmpeg() {
        if (sIFFmpegLoader != null) {
            sHasLoadFFmpeg = sIFFmpegLoader.loadFFmpeg();
        } else {
            if (sHasLoadFFmpeg) {
                return true;
            }
            try {
                System.loadLibrary("ttcrypto");
                System.loadLibrary("ttboringssl");
                System.loadLibrary("ttffmpeg");
                sHasLoadFFmpeg = true;
            }
            catch (UnsatisfiedLinkError error) {
                Log.e((String)TAG, (String)("load ffmpeg lib failed " + error.getMessage()));
            }
        }
        return true;
    }

    public static synchronized void setFFmpegLoader(IFFmpegLoader loader) {
        sIFFmpegLoader = loader;
    }

    public static synchronized void setFFmpegVerifyLoader(IVerifyLoader loader) {
        sIFFmpegVerifyLoader = loader;
    }

    public static synchronized String getFFmpegVersion() {
        return "1.1.106.201-tob";
    }

    public static List<String> getFFmpegLibs() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            list.add("ttcrypto");
            list.add("ttboringssl");
            list.add("ttffmpeg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static synchronized boolean tryLoadVcnverifylib() {
        if (isVcnverifyload) {
            return true;
        }
        if (sIFFmpegVerifyLoader != null) {
            isVcnverifyload = sIFFmpegVerifyLoader.loadVerifyLib();
            return isVcnverifyload;
        }
        boolean result = true;
        try {
            System.loadLibrary("ttmverify");
        }
        catch (UnsatisfiedLinkError error) {
            Log.e((String)"ttmverify", (String)("Can't load ttmverify library: " + error));
            try {
                System.loadLibrary("ttmverifylite");
                Log.e((String)"ttmverifylite", (String)"load ttmverifylite library suc");
                CustomVerify.init();
            }
            catch (UnsatisfiedLinkError error1) {
                Log.e((String)"ttmverifylite", (String)("Can't load ttmverifylite library: " + error1));
                result = false;
            }
        }
        isVcnverifyload = result;
        return result;
    }
}

