/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.api;

import com.bynder.sdk.api.AmazonS3Api;
import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.api.OAuthApi;
import com.bynder.sdk.configuration.Configuration;
import com.bynder.sdk.configuration.HttpConnectionSettings;
import com.bynder.sdk.exception.BynderRuntimeException;
import com.bynder.sdk.model.oauth.Token;
import com.bynder.sdk.service.BynderClient;
import com.bynder.sdk.service.oauth.OAuthService;
import com.bynder.sdk.util.BooleanTypeAdapter;
import com.bynder.sdk.util.StringConverterFactory;
import com.bynder.sdk.util.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class ApiFactory {
    private ApiFactory() {
    }

    public static BynderApi createBynderClient(Configuration configuration) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Boolean.class, (Object)new BooleanTypeAdapter());
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(configuration.getBaseUrl().toString()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)new StringConverterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gsonBuilder.create()));
        Retrofit retrofit = retrofitBuilder.client(ApiFactory.createOkHttpClient(configuration)).build();
        return (BynderApi)retrofit.create(BynderApi.class);
    }

    public static AmazonS3Api createAmazonS3Client(String bucket) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(bucket).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        Retrofit retrofit = retrofitBuilder.build();
        return (AmazonS3Api)retrofit.create(AmazonS3Api.class);
    }

    public static OAuthApi createOAuthClient(String baseUrl) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        Retrofit retrofit = retrofitBuilder.build();
        return (OAuthApi)retrofit.create(OAuthApi.class);
    }

    private static OkHttpClient createOkHttpClient(Configuration configuration) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        if (configuration.getPermanentToken() == null) {
            ApiFactory.setOAuthInterceptor(httpClientBuilder, configuration);
        } else {
            ApiFactory.setPermanentTokenInterceptor(httpClientBuilder, configuration);
        }
        HttpConnectionSettings httpConnectionSettings = configuration.getHttpConnectionSettings();
        ApiFactory.setHttpConnectionSettings(httpClientBuilder, httpConnectionSettings);
        return httpClientBuilder.build();
    }

    private static void setOAuthInterceptor(OkHttpClient.Builder httpClientBuilder, final Configuration configuration) {
        httpClientBuilder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                if (configuration.getOAuthSettings().getToken() == null) {
                    throw new BynderRuntimeException("Token is not defined in Configuration");
                }
                if (Utils.isDateExpiring(configuration.getOAuthSettings().getToken().getAccessTokenExpiration(), 15)) {
                    OAuthService oAuthService = BynderClient.Builder.create(configuration).getOAuthService();
                    Token token = (Token)oAuthService.refreshAccessToken().blockingSingle();
                    configuration.getOAuthSettings().callback(token);
                }
                String headerValue = String.format("%s %s", "Bearer", configuration.getOAuthSettings().getToken().getAccessToken());
                Request.Builder requestBuilder = chain.request().newBuilder().header("Authorization", headerValue);
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        });
    }

    private static void setPermanentTokenInterceptor(OkHttpClient.Builder httpClientBuilder, final Configuration configuration) {
        httpClientBuilder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                String headerValue = String.format("%s %s", "Bearer", configuration.getPermanentToken());
                Request.Builder requestBuilder = chain.request().newBuilder().header("Authorization", headerValue);
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        });
    }

    private static void setHttpConnectionSettings(OkHttpClient.Builder httpClientBuilder, HttpConnectionSettings httpConnectionSettings) {
        if (httpConnectionSettings.isLoggingInterceptorEnabled()) {
            HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
            httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            httpClientBuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        }
        if (httpConnectionSettings.getCustomInterceptor() != null) {
            httpClientBuilder.addInterceptor(httpConnectionSettings.getCustomInterceptor());
        }
        httpClientBuilder.retryOnConnectionFailure(httpConnectionSettings.isRetryOnConnectionFailure());
        httpClientBuilder.readTimeout((long)httpConnectionSettings.getReadTimeoutSeconds(), TimeUnit.SECONDS);
        httpClientBuilder.connectTimeout((long)httpConnectionSettings.getConnectTimeoutSeconds(), TimeUnit.SECONDS);
        httpClientBuilder.writeTimeout((long)httpConnectionSettings.getConnectTimeoutSeconds(), TimeUnit.SECONDS);
        if (httpConnectionSettings.getSslContext() != null && httpConnectionSettings.getTrustManager() != null) {
            httpClientBuilder.sslSocketFactory(httpConnectionSettings.getSslContext().getSocketFactory(), httpConnectionSettings.getTrustManager());
        }
    }
}

