/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.service.collection;

import com.bynder.sdk.api.BynderApi;
import com.bynder.sdk.model.Collection;
import com.bynder.sdk.query.collection.CollectionAddMediaQuery;
import com.bynder.sdk.query.collection.CollectionCreateQuery;
import com.bynder.sdk.query.collection.CollectionInfoQuery;
import com.bynder.sdk.query.collection.CollectionQuery;
import com.bynder.sdk.query.collection.CollectionRemoveMediaQuery;
import com.bynder.sdk.query.collection.CollectionShareQuery;
import com.bynder.sdk.query.decoder.QueryDecoder;
import com.bynder.sdk.service.collection.CollectionService;
import io.reactivex.Observable;
import java.util.List;
import java.util.Map;
import retrofit2.Response;

public class CollectionServiceImpl
implements CollectionService {
    private final BynderApi bynderApi;
    private final QueryDecoder queryDecoder;

    public CollectionServiceImpl(BynderApi bynderApi, QueryDecoder queryDecoder) {
        this.bynderApi = bynderApi;
        this.queryDecoder = queryDecoder;
    }

    @Override
    public Observable<Response<List<Collection>>> getCollections(CollectionQuery collectionQuery) {
        Map<String, String> params = this.queryDecoder.decode(collectionQuery);
        return this.bynderApi.getCollections(params);
    }

    @Override
    public Observable<Response<Collection>> getCollectionInfo(CollectionInfoQuery collectionInfoQuery) {
        Map<String, String> params = this.queryDecoder.decode(collectionInfoQuery);
        return this.bynderApi.getCollectionInfo(params);
    }

    @Override
    public Observable<Response<Void>> createCollection(CollectionCreateQuery collectionCreateQuery) {
        Map<String, String> params = this.queryDecoder.decode(collectionCreateQuery);
        return this.bynderApi.createCollection(params);
    }

    @Override
    public Observable<Response<Void>> deleteCollection(CollectionInfoQuery collectionInfoQuery) {
        Map<String, String> params = this.queryDecoder.decode(collectionInfoQuery);
        return this.bynderApi.deleteCollection(params);
    }

    @Override
    public Observable<Response<List<String>>> getCollectionMediaIds(CollectionInfoQuery collectionInfoQuery) {
        return this.bynderApi.getCollectionMediaIds(collectionInfoQuery.getCollectionId());
    }

    @Override
    public Observable<Response<Void>> addMediaToCollection(CollectionAddMediaQuery collectionAddMediaQuery) {
        Map<String, String> params = this.queryDecoder.decode(collectionAddMediaQuery);
        return this.bynderApi.addMediaToCollection(collectionAddMediaQuery.getCollectionId(), params);
    }

    @Override
    public Observable<Response<Void>> removeMediaFromCollection(CollectionRemoveMediaQuery collectionRemoveMediaQuery) {
        Map<String, String> params = this.queryDecoder.decode(collectionRemoveMediaQuery);
        return this.bynderApi.removeMediaFromCollection(collectionRemoveMediaQuery.getCollectionId(), params);
    }

    @Override
    public Observable<Response<Void>> shareCollection(CollectionShareQuery collectionShareQuery) {
        Map<String, String> params = this.queryDecoder.decode(collectionShareQuery);
        return this.bynderApi.shareCollection(collectionShareQuery.getCollectionId(), params);
    }
}

