/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.ndk;

import android.os.Build;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.StateEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086 J\t\u0010\u0015\u001a\u00020\u000fH\u0086 J!\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0006H\u0086 J!\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001bH\u0086 J!\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0086 J\t\u0010\u001d\u001a\u00020\u000fH\u0086 J\u0011\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\rH\u0086 J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0011\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\rH\u0086 J\t\u0010\"\u001a\u00020#H\u0086 J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020(H\u0002JY\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020.2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\rH\u0086 J\u0012\u00104\u001a\u00020\u00062\b\u00105\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\rH\u0002J\t\u00108\u001a\u00020\u000fH\u0086 J\u0019\u00109\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0086 J)\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020.H\u0086 J\u001a\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020@2\b\u0010%\u001a\u0004\u0018\u00010\u0014H\u0016J\u0011\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\rH\u0086 J\u0019\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\rH\u0086 J\u0011\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u0006H\u0086 J\u0011\u0010H\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0086 J\u0011\u0010I\u001a\u00020\u000f2\u0006\u0010J\u001a\u00020\rH\u0086 J\u0011\u0010K\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\rH\u0086 J\u0011\u0010M\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\rH\u0086 J\u0011\u0010N\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\rH\u0086 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/bugsnag/android/ndk/NativeBridge;", "Ljava/util/Observer;", "()V", "installed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "is32bit", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lcom/bugsnag/android/Logger;", "reportDirectory", "", "addBreadcrumb", "", "name", "type", "timestamp", "metadata", "", "addHandledEvent", "addMetadataBoolean", "tab", "key", "value", "addMetadataDouble", "", "addMetadataString", "addUnhandledEvent", "clearMetadataTab", "deliverPendingReports", "deliverReportAtPath", "filePath", "getUnwindStackFunction", "", "handleAddMetadata", "arg", "Lcom/bugsnag/android/StateEvent$AddMetadata;", "handleInstallMessage", "Lcom/bugsnag/android/StateEvent$Install;", "install", "apiKey", "reportingDirectory", "lastRunInfoPath", "consecutiveLaunchCrashes", "", "autoDetectNdkCrashes", "apiLevel", "appVersion", "buildUuid", "releaseStage", "isInvalidMessage", "msg", "makeSafe", "text", "pausedSession", "removeMetadata", "startedSession", "sessionID", "handledCount", "unhandledCount", "update", "observable", "Ljava/util/Observable;", "updateContext", "context", "updateInForeground", "inForeground", "activityName", "updateIsLaunching", "isLaunching", "updateLastRunInfo", "updateOrientation", "orientation", "updateUserEmail", "newValue", "updateUserId", "updateUserName", "bugsnag-plugin-android-ndk_release"})
public final class NativeBridge
implements Observer {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean installed = new AtomicBoolean(false);
    private final String reportDirectory;
    private final Logger logger;

    private final boolean is32bit() {
        boolean bl;
        block3: {
            Object[] objectArray = NativeInterface.getCpuAbi();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"NativeInterface.getCpuAbi()");
            Object[] abis = objectArray;
            Iterable $this$any$iv = ArraysKt.toList((Object[])abis);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"64", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    public final native void install(@NotNull String var1, @NotNull String var2, @NotNull String var3, int var4, boolean var5, int var6, boolean var7, @NotNull String var8, @NotNull String var9, @NotNull String var10);

    public final native void startedSession(@NotNull String var1, @NotNull String var2, int var3, int var4);

    public final native void deliverReportAtPath(@NotNull String var1);

    public final native void addBreadcrumb(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull Object var4);

    public final native void addMetadataString(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public final native void addMetadataDouble(@NotNull String var1, @NotNull String var2, double var3);

    public final native void addMetadataBoolean(@NotNull String var1, @NotNull String var2, boolean var3);

    public final native void addHandledEvent();

    public final native void addUnhandledEvent();

    public final native void clearMetadataTab(@NotNull String var1);

    public final native void removeMetadata(@NotNull String var1, @NotNull String var2);

    public final native void pausedSession();

    public final native void updateContext(@NotNull String var1);

    public final native void updateInForeground(boolean var1, @NotNull String var2);

    public final native void updateIsLaunching(boolean var1);

    public final native void updateLastRunInfo(int var1);

    public final native void updateOrientation(@NotNull String var1);

    public final native void updateUserId(@NotNull String var1);

    public final native void updateUserEmail(@NotNull String var1);

    public final native void updateUserName(@NotNull String var1);

    public final native long getUnwindStackFunction();

    @Override
    public void update(@NotNull Observable observable, @Nullable Object arg) {
        block10: {
            StateEvent msg;
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block13: {
                                                            block12: {
                                                                block11: {
                                                                    block9: {
                                                                        Intrinsics.checkParameterIsNotNull((Object)observable, (String)"observable");
                                                                        if (this.isInvalidMessage(arg)) {
                                                                            return;
                                                                        }
                                                                        Object object = arg;
                                                                        if (object == null) {
                                                                            throw new TypeCastException("null cannot be cast to non-null type com.bugsnag.android.StateEvent");
                                                                        }
                                                                        msg = (StateEvent)object;
                                                                        if (!(msg instanceof StateEvent.Install)) break block9;
                                                                        this.handleInstallMessage((StateEvent.Install)msg);
                                                                        break block10;
                                                                    }
                                                                    if (!Intrinsics.areEqual((Object)msg, (Object)StateEvent.DeliverPending.INSTANCE)) break block11;
                                                                    this.deliverPendingReports();
                                                                    break block10;
                                                                }
                                                                if (!(msg instanceof StateEvent.AddMetadata)) break block12;
                                                                this.handleAddMetadata((StateEvent.AddMetadata)msg);
                                                                break block10;
                                                            }
                                                            if (!(msg instanceof StateEvent.ClearMetadataSection)) break block13;
                                                            this.clearMetadataTab(this.makeSafe(((StateEvent.ClearMetadataSection)msg).getSection()));
                                                            break block10;
                                                        }
                                                        if (!(msg instanceof StateEvent.ClearMetadataValue)) break block14;
                                                        String string = this.makeSafe(((StateEvent.ClearMetadataValue)msg).getSection());
                                                        String string2 = ((StateEvent.ClearMetadataValue)msg).getKey();
                                                        if (string2 == null) {
                                                            string2 = "";
                                                        }
                                                        this.removeMetadata(string, this.makeSafe(string2));
                                                        break block10;
                                                    }
                                                    if (!(msg instanceof StateEvent.AddBreadcrumb)) break block15;
                                                    this.addBreadcrumb(this.makeSafe(((StateEvent.AddBreadcrumb)msg).getMessage()), this.makeSafe(((StateEvent.AddBreadcrumb)msg).getType().toString()), this.makeSafe(((StateEvent.AddBreadcrumb)msg).getTimestamp()), ((StateEvent.AddBreadcrumb)msg).getMetadata());
                                                    break block10;
                                                }
                                                if (!Intrinsics.areEqual((Object)msg, (Object)StateEvent.NotifyHandled.INSTANCE)) break block16;
                                                this.addHandledEvent();
                                                break block10;
                                            }
                                            if (!Intrinsics.areEqual((Object)msg, (Object)StateEvent.NotifyUnhandled.INSTANCE)) break block17;
                                            this.addUnhandledEvent();
                                            break block10;
                                        }
                                        if (!Intrinsics.areEqual((Object)msg, (Object)StateEvent.PauseSession.INSTANCE)) break block18;
                                        this.pausedSession();
                                        break block10;
                                    }
                                    if (!(msg instanceof StateEvent.StartSession)) break block19;
                                    this.startedSession(this.makeSafe(((StateEvent.StartSession)msg).getId()), this.makeSafe(((StateEvent.StartSession)msg).getStartedAt()), ((StateEvent.StartSession)msg).getHandledCount(), ((StateEvent.StartSession)msg).getUnhandledCount());
                                    break block10;
                                }
                                if (!(msg instanceof StateEvent.UpdateContext)) break block20;
                                String string = ((StateEvent.UpdateContext)msg).getContext();
                                if (string == null) {
                                    string = "";
                                }
                                this.updateContext(this.makeSafe(string));
                                break block10;
                            }
                            if (!(msg instanceof StateEvent.UpdateInForeground)) break block21;
                            boolean bl = ((StateEvent.UpdateInForeground)msg).getInForeground();
                            String string = ((StateEvent.UpdateInForeground)msg).getContextActivity();
                            if (string == null) {
                                string = "";
                            }
                            this.updateInForeground(bl, this.makeSafe(string));
                            break block10;
                        }
                        if (!(msg instanceof StateEvent.UpdateLastRunInfo)) break block22;
                        this.updateLastRunInfo(((StateEvent.UpdateLastRunInfo)msg).getConsecutiveLaunchCrashes());
                        break block10;
                    }
                    if (!(msg instanceof StateEvent.UpdateIsLaunching)) break block23;
                    this.updateIsLaunching(((StateEvent.UpdateIsLaunching)msg).isLaunching());
                    break block10;
                }
                if (!(msg instanceof StateEvent.UpdateOrientation)) break block24;
                String string = ((StateEvent.UpdateOrientation)msg).getOrientation();
                if (string == null) {
                    string = "";
                }
                this.updateOrientation(string);
                break block10;
            }
            if (!(msg instanceof StateEvent.UpdateUser)) break block10;
            String string = ((StateEvent.UpdateUser)msg).getUser().getId();
            if (string == null) {
                string = "";
            }
            this.updateUserId(this.makeSafe(string));
            String string3 = ((StateEvent.UpdateUser)msg).getUser().getName();
            if (string3 == null) {
                string3 = "";
            }
            this.updateUserName(this.makeSafe(string3));
            String string4 = ((StateEvent.UpdateUser)msg).getUser().getEmail();
            if (string4 == null) {
                string4 = "";
            }
            this.updateUserEmail(this.makeSafe(string4));
        }
    }

    private final boolean isInvalidMessage(Object msg) {
        if (msg == null || !(msg instanceof StateEvent)) {
            return true;
        }
        if (!this.installed.get() && !(msg instanceof StateEvent.Install)) {
            this.logger.w("Received message before INSTALL: " + msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deliverPendingReports() {
        this.lock.lock();
        try {
            File outDir = new File(this.reportDirectory);
            if (outDir.exists()) {
                File[] fileList = outDir.listFiles();
                if (fileList != null) {
                    File[] fileArray = fileList;
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File file;
                        File file2 = file = fileArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        String string = file2.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
                        this.deliverReportAtPath(string);
                    }
                }
            } else {
                this.logger.w("Payload directory does not exist, cannot read pending reports");
            }
        }
        catch (Exception ex) {
            this.logger.w("Failed to parse/write pending reports: " + ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInstallMessage(StateEvent.Install arg) {
        this.lock.lock();
        try {
            if (this.installed.get()) {
                this.logger.w("Received duplicate setup message with arg: " + arg);
            } else {
                String reportPath = new File(this.reportDirectory, UUID.randomUUID() + ".crash").getAbsolutePath();
                String string = this.makeSafe(arg.getApiKey());
                String string2 = reportPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"reportPath");
                String string3 = this.makeSafe(arg.getLastRunInfoPath());
                int n = arg.getConsecutiveLaunchCrashes();
                boolean bl = arg.getAutoDetectNdkCrashes();
                boolean bl2 = this.is32bit();
                String string4 = arg.getAppVersion();
                if (string4 == null) {
                    string4 = "";
                }
                String string5 = this.makeSafe(string4);
                String string6 = arg.getBuildUuid();
                if (string6 == null) {
                    string6 = "";
                }
                String string7 = this.makeSafe(string6);
                String string8 = arg.getReleaseStage();
                if (string8 == null) {
                    string8 = "";
                }
                this.install(string, string2, string3, n, bl, Build.VERSION.SDK_INT, bl2, string5, string7, this.makeSafe(string8));
                this.installed.set(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void handleAddMetadata(StateEvent.AddMetadata arg) {
        block3: {
            Object newValue;
            block5: {
                block4: {
                    if (arg.getKey() == null) break block3;
                    newValue = arg.getValue();
                    if (!(newValue instanceof String)) break block4;
                    String string = arg.getSection();
                    String string2 = arg.getKey();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.addMetadataString(string, string2, this.makeSafe((String)newValue));
                    break block3;
                }
                if (!(newValue instanceof Boolean)) break block5;
                String string = arg.getSection();
                String string3 = arg.getKey();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                this.addMetadataBoolean(string, string3, (Boolean)newValue);
                break block3;
            }
            if (!(newValue instanceof Number)) break block3;
            String string = arg.getSection();
            String string4 = arg.getKey();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            this.addMetadataDouble(string, string4, ((Number)newValue).doubleValue());
        }
    }

    private final String makeSafe(String text) {
        Object object = text;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        boolean bl2 = false;
        return new String((byte[])object, Charsets.UTF_8);
    }

    public NativeBridge() {
        String string = NativeInterface.getNativeReportPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"NativeInterface.getNativeReportPath()");
        this.reportDirectory = string;
        Logger logger = NativeInterface.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"NativeInterface.getLogger()");
        this.logger = logger;
        File outFile = new File(this.reportDirectory);
        NativeInterface.getLogger();
        if (!outFile.exists() && !outFile.mkdirs()) {
            this.logger.w("The native reporting directory cannot be created.");
        }
    }
}

