/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.ndk;

import android.os.Build;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.internal.StateObserver;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0086 J\t\u0010\u0015\u001a\u00020\u000fH\u0086 J!\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0006H\u0086 J!\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001bH\u0086 J!\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0086 J\t\u0010\u001d\u001a\u00020\u000fH\u0086 J\u0011\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\rH\u0086 J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0011\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\rH\u0086 J\t\u0010\"\u001a\u00020#H\u0086 J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020(H\u0002JI\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020.2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00101\u001a\u00020.H\u0086 J\u0012\u00102\u001a\u00020\u00062\b\u00103\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\rH\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u000208H\u0016J\t\u00109\u001a\u00020\u000fH\u0086 J\u0019\u0010:\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0086 J)\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020.H\u0086 J\u0011\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\rH\u0086 J\u0019\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\rH\u0086 J\u0011\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u0006H\u0086 J\u0011\u0010F\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.H\u0086 J\u0019\u0010G\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\rH\u0086 J\u0011\u0010J\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\rH\u0086 J\u0011\u0010L\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\rH\u0086 J\u0011\u0010M\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\rH\u0086 J\u0011\u0010N\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\rH\u0086 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/bugsnag/android/ndk/NativeBridge;", "Lcom/bugsnag/android/internal/StateObserver;", "()V", "installed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "is32bit", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lcom/bugsnag/android/Logger;", "reportDirectory", "", "addBreadcrumb", "", "name", "type", "timestamp", "metadata", "", "addHandledEvent", "addMetadataBoolean", "tab", "key", "value", "addMetadataDouble", "", "addMetadataString", "addUnhandledEvent", "clearMetadataTab", "deliverPendingReports", "deliverReportAtPath", "filePath", "getSignalUnwindStackFunction", "", "handleAddMetadata", "arg", "Lcom/bugsnag/android/StateEvent$AddMetadata;", "handleInstallMessage", "Lcom/bugsnag/android/StateEvent$Install;", "install", "apiKey", "reportingDirectory", "lastRunInfoPath", "consecutiveLaunchCrashes", "", "autoDetectNdkCrashes", "apiLevel", "threadSendPolicy", "isInvalidMessage", "msg", "makeSafe", "text", "onStateChange", "event", "Lcom/bugsnag/android/StateEvent;", "pausedSession", "removeMetadata", "startedSession", "sessionID", "handledCount", "unhandledCount", "updateContext", "context", "updateInForeground", "inForeground", "activityName", "updateIsLaunching", "isLaunching", "updateLastRunInfo", "updateLowMemory", "newValue", "memoryTrimLevelDescription", "updateOrientation", "orientation", "updateUserEmail", "updateUserId", "updateUserName", "bugsnag-plugin-android-ndk_release"})
public final class NativeBridge
implements StateObserver {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean installed = new AtomicBoolean(false);
    private final String reportDirectory;
    private final Logger logger;

    private final boolean is32bit() {
        boolean bl;
        block3: {
            Object[] objectArray = NativeInterface.getCpuAbi();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"NativeInterface.getCpuAbi()");
            Object[] abis = objectArray;
            Iterable $this$any$iv = ArraysKt.toList((Object[])abis);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"64", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    public final native void install(@NotNull String var1, @NotNull String var2, @NotNull String var3, int var4, boolean var5, int var6, boolean var7, int var8);

    public final native void startedSession(@NotNull String var1, @NotNull String var2, int var3, int var4);

    public final native void deliverReportAtPath(@NotNull String var1);

    public final native void addBreadcrumb(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull Object var4);

    public final native void addMetadataString(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public final native void addMetadataDouble(@NotNull String var1, @NotNull String var2, double var3);

    public final native void addMetadataBoolean(@NotNull String var1, @NotNull String var2, boolean var3);

    public final native void addHandledEvent();

    public final native void addUnhandledEvent();

    public final native void clearMetadataTab(@NotNull String var1);

    public final native void removeMetadata(@NotNull String var1, @NotNull String var2);

    public final native void pausedSession();

    public final native void updateContext(@NotNull String var1);

    public final native void updateInForeground(boolean var1, @NotNull String var2);

    public final native void updateIsLaunching(boolean var1);

    public final native void updateLastRunInfo(int var1);

    public final native void updateOrientation(@NotNull String var1);

    public final native void updateUserId(@NotNull String var1);

    public final native void updateUserEmail(@NotNull String var1);

    public final native void updateUserName(@NotNull String var1);

    public final native long getSignalUnwindStackFunction();

    public final native void updateLowMemory(boolean var1, @NotNull String var2);

    public void onStateChange(@NotNull StateEvent event) {
        block9: {
            StateEvent stateEvent;
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        block13: {
                                                            block12: {
                                                                block11: {
                                                                    block10: {
                                                                        block8: {
                                                                            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                                                                            if (this.isInvalidMessage(event)) {
                                                                                return;
                                                                            }
                                                                            stateEvent = event;
                                                                            if (!(stateEvent instanceof StateEvent.Install)) break block8;
                                                                            this.handleInstallMessage((StateEvent.Install)event);
                                                                            break block9;
                                                                        }
                                                                        if (!Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.DeliverPending.INSTANCE)) break block10;
                                                                        this.deliverPendingReports();
                                                                        break block9;
                                                                    }
                                                                    if (!(stateEvent instanceof StateEvent.AddMetadata)) break block11;
                                                                    this.handleAddMetadata((StateEvent.AddMetadata)event);
                                                                    break block9;
                                                                }
                                                                if (!(stateEvent instanceof StateEvent.ClearMetadataSection)) break block12;
                                                                this.clearMetadataTab(this.makeSafe(((StateEvent.ClearMetadataSection)event).section));
                                                                break block9;
                                                            }
                                                            if (!(stateEvent instanceof StateEvent.ClearMetadataValue)) break block13;
                                                            String string = this.makeSafe(((StateEvent.ClearMetadataValue)event).section);
                                                            String string2 = ((StateEvent.ClearMetadataValue)event).key;
                                                            if (string2 == null) {
                                                                string2 = "";
                                                            }
                                                            this.removeMetadata(string, this.makeSafe(string2));
                                                            break block9;
                                                        }
                                                        if (!(stateEvent instanceof StateEvent.AddBreadcrumb)) break block14;
                                                        this.addBreadcrumb(this.makeSafe(((StateEvent.AddBreadcrumb)event).message), this.makeSafe(((StateEvent.AddBreadcrumb)event).type.toString()), this.makeSafe(((StateEvent.AddBreadcrumb)event).timestamp), ((StateEvent.AddBreadcrumb)event).metadata);
                                                        break block9;
                                                    }
                                                    if (!Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.NotifyHandled.INSTANCE)) break block15;
                                                    this.addHandledEvent();
                                                    break block9;
                                                }
                                                if (!Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.NotifyUnhandled.INSTANCE)) break block16;
                                                this.addUnhandledEvent();
                                                break block9;
                                            }
                                            if (!Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.PauseSession.INSTANCE)) break block17;
                                            this.pausedSession();
                                            break block9;
                                        }
                                        if (!(stateEvent instanceof StateEvent.StartSession)) break block18;
                                        this.startedSession(this.makeSafe(((StateEvent.StartSession)event).id), this.makeSafe(((StateEvent.StartSession)event).startedAt), ((StateEvent.StartSession)event).handledCount, ((StateEvent.StartSession)event).getUnhandledCount());
                                        break block9;
                                    }
                                    if (!(stateEvent instanceof StateEvent.UpdateContext)) break block19;
                                    String string = ((StateEvent.UpdateContext)event).context;
                                    if (string == null) {
                                        string = "";
                                    }
                                    this.updateContext(this.makeSafe(string));
                                    break block9;
                                }
                                if (!(stateEvent instanceof StateEvent.UpdateInForeground)) break block20;
                                boolean bl = ((StateEvent.UpdateInForeground)event).inForeground;
                                String string = ((StateEvent.UpdateInForeground)event).getContextActivity();
                                if (string == null) {
                                    string = "";
                                }
                                this.updateInForeground(bl, this.makeSafe(string));
                                break block9;
                            }
                            if (!(stateEvent instanceof StateEvent.UpdateLastRunInfo)) break block21;
                            this.updateLastRunInfo(((StateEvent.UpdateLastRunInfo)event).consecutiveLaunchCrashes);
                            break block9;
                        }
                        if (!(stateEvent instanceof StateEvent.UpdateIsLaunching)) break block22;
                        this.updateIsLaunching(((StateEvent.UpdateIsLaunching)event).isLaunching);
                        break block9;
                    }
                    if (!(stateEvent instanceof StateEvent.UpdateOrientation)) break block23;
                    String string = ((StateEvent.UpdateOrientation)event).orientation;
                    if (string == null) {
                        string = "";
                    }
                    this.updateOrientation(string);
                    break block9;
                }
                if (!(stateEvent instanceof StateEvent.UpdateUser)) break block24;
                String string = ((StateEvent.UpdateUser)event).user.getId();
                if (string == null) {
                    string = "";
                }
                this.updateUserId(this.makeSafe(string));
                String string3 = ((StateEvent.UpdateUser)event).user.getName();
                if (string3 == null) {
                    string3 = "";
                }
                this.updateUserName(this.makeSafe(string3));
                String string4 = ((StateEvent.UpdateUser)event).user.getEmail();
                if (string4 == null) {
                    string4 = "";
                }
                this.updateUserEmail(this.makeSafe(string4));
                break block9;
            }
            if (!(stateEvent instanceof StateEvent.UpdateMemoryTrimEvent)) break block9;
            this.updateLowMemory(((StateEvent.UpdateMemoryTrimEvent)event).isLowMemory, ((StateEvent.UpdateMemoryTrimEvent)event).memoryTrimLevelDescription);
        }
    }

    private final boolean isInvalidMessage(Object msg) {
        if (msg == null || !(msg instanceof StateEvent)) {
            return true;
        }
        if (!this.installed.get() && !(msg instanceof StateEvent.Install)) {
            this.logger.w("Received message before INSTALL: " + msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deliverPendingReports() {
        this.lock.lock();
        try {
            File outDir = new File(this.reportDirectory);
            if (outDir.exists()) {
                File[] fileList = outDir.listFiles();
                if (fileList != null) {
                    File[] fileArray = fileList;
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File file;
                        File file2 = file = fileArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        String string = file2.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
                        this.deliverReportAtPath(string);
                    }
                }
            } else {
                this.logger.w("Payload directory does not exist, cannot read pending reports");
            }
        }
        catch (Exception ex) {
            this.logger.w("Failed to parse/write pending reports: " + ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInstallMessage(StateEvent.Install arg) {
        this.lock.lock();
        try {
            if (this.installed.get()) {
                this.logger.w("Received duplicate setup message with arg: " + arg);
            } else {
                String reportPath = new File(this.reportDirectory, UUID.randomUUID() + ".crash").getAbsolutePath();
                String string = this.makeSafe(arg.apiKey);
                String string2 = reportPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"reportPath");
                this.install(string, string2, this.makeSafe(arg.lastRunInfoPath), arg.consecutiveLaunchCrashes, arg.autoDetectNdkCrashes, Build.VERSION.SDK_INT, this.is32bit(), arg.sendThreads.ordinal());
                this.installed.set(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void handleAddMetadata(StateEvent.AddMetadata arg) {
        block3: {
            Object newValue;
            block5: {
                block4: {
                    if (arg.key == null) break block3;
                    newValue = arg.value;
                    if (!(newValue instanceof String)) break block4;
                    String string = arg.section;
                    String string2 = arg.key;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.addMetadataString(string, string2, this.makeSafe((String)newValue));
                    break block3;
                }
                if (!(newValue instanceof Boolean)) break block5;
                String string = arg.section;
                String string3 = arg.key;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                this.addMetadataBoolean(string, string3, (Boolean)newValue);
                break block3;
            }
            if (!(newValue instanceof Number)) break block3;
            String string = arg.section;
            String string4 = arg.key;
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            this.addMetadataDouble(string, string4, ((Number)newValue).doubleValue());
        }
    }

    private final String makeSafe(String text) {
        Object object = text;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        boolean bl2 = false;
        return new String((byte[])object, Charsets.UTF_8);
    }

    public NativeBridge() {
        String string = NativeInterface.getNativeReportPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"NativeInterface.getNativeReportPath()");
        this.reportDirectory = string;
        Logger logger = NativeInterface.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"NativeInterface.getLogger()");
        this.logger = logger;
    }
}

