/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.BeforeRecordBreadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Callback;
import com.bugsnag.android.Client;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.Report;
import com.bugsnag.android.SessionTrackingApiClient;
import com.bugsnag.android.Severity;
import java.util.Map;

public final class Bugsnag {
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    static Client client;

    private Bugsnag() {
    }

    @NonNull
    public static Client init(@NonNull Context androidContext) {
        client = new Client(androidContext);
        NativeInterface.configureClientObservers(client);
        return client;
    }

    @NonNull
    public static Client init(@NonNull Context androidContext, @Nullable String apiKey) {
        client = new Client(androidContext, apiKey);
        NativeInterface.configureClientObservers(client);
        return client;
    }

    @NonNull
    public static Client init(@NonNull Context androidContext, @Nullable String apiKey, boolean enableExceptionHandler) {
        client = new Client(androidContext, apiKey, enableExceptionHandler);
        NativeInterface.configureClientObservers(client);
        return client;
    }

    @NonNull
    public static Client init(@NonNull Context androidContext, @NonNull Configuration config) {
        client = new Client(androidContext, config);
        NativeInterface.configureClientObservers(client);
        return client;
    }

    public static void setAppVersion(String appVersion) {
        Bugsnag.getClient().setAppVersion(appVersion);
    }

    public static String getContext() {
        return Bugsnag.getClient().getContext();
    }

    public static void setContext(String context) {
        Bugsnag.getClient().setContext(context);
    }

    @Deprecated
    public static void setEndpoint(String endpoint) {
        Bugsnag.getClient().setEndpoint(endpoint);
    }

    public static void setBuildUUID(String buildUuid) {
        Bugsnag.getClient().setBuildUUID(buildUuid);
    }

    public static void setFilters(String ... filters) {
        Bugsnag.getClient().setFilters(filters);
    }

    public static void setIgnoreClasses(String ... ignoreClasses) {
        Bugsnag.getClient().setIgnoreClasses(ignoreClasses);
    }

    public static void setNotifyReleaseStages(String ... notifyReleaseStages) {
        Bugsnag.getClient().setNotifyReleaseStages(notifyReleaseStages);
    }

    public static void setProjectPackages(String ... projectPackages) {
        Bugsnag.getClient().setProjectPackages(projectPackages);
    }

    public static void setReleaseStage(String releaseStage) {
        Bugsnag.getClient().setReleaseStage(releaseStage);
    }

    public static void setSendThreads(boolean sendThreads) {
        Bugsnag.getClient().setSendThreads(sendThreads);
    }

    public static void setAutoCaptureSessions(boolean autoCapture) {
        Bugsnag.getClient().setAutoCaptureSessions(autoCapture);
    }

    public static void setUser(String id, String email, String name) {
        Bugsnag.getClient().setUser(id, email, name);
    }

    public static void clearUser() {
        Bugsnag.getClient().clearUser();
    }

    public static void setUserId(String id) {
        Bugsnag.getClient().setUserId(id);
    }

    public static void setUserEmail(String email) {
        Bugsnag.getClient().setUserEmail(email);
    }

    public static void setUserName(String name) {
        Bugsnag.getClient().setUserName(name);
    }

    @Deprecated
    public static void setErrorReportApiClient(@NonNull ErrorReportApiClient errorReportApiClient) {
        Bugsnag.getClient().setErrorReportApiClient(errorReportApiClient);
    }

    @Deprecated
    public static void setSessionTrackingApiClient(@NonNull SessionTrackingApiClient apiClient) {
        Bugsnag.getClient().setSessionTrackingApiClient(apiClient);
    }

    public static void beforeNotify(BeforeNotify beforeNotify) {
        Bugsnag.getClient().beforeNotify(beforeNotify);
    }

    public static void beforeRecordBreadcrumb(BeforeRecordBreadcrumb beforeRecordBreadcrumb) {
        Bugsnag.getClient().beforeRecordBreadcrumb(beforeRecordBreadcrumb);
    }

    public static void notify(@NonNull Throwable exception) {
        Bugsnag.getClient().notify(exception);
    }

    public static void notify(@NonNull Throwable exception, Callback callback) {
        Bugsnag.getClient().notify(exception, callback);
    }

    public static void notify(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, Callback callback) {
        Bugsnag.getClient().notify(name, message, stacktrace, callback);
    }

    public static void notify(@NonNull Throwable exception, Severity severity) {
        Bugsnag.getClient().notify(exception, severity);
    }

    @Deprecated
    public static void notify(@NonNull Throwable exception, final @NonNull MetaData metaData) {
        Bugsnag.getClient().notify(exception, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setMetaData(metaData);
            }
        });
    }

    @Deprecated
    public static void notify(@NonNull Throwable exception, final Severity severity, final @NonNull MetaData metaData) {
        Bugsnag.getClient().notify(exception, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setSeverity(severity);
                report.getError().setMetaData(metaData);
            }
        });
    }

    @Deprecated
    public static void notify(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, Severity severity, @NonNull MetaData metaData) {
        final Severity finalSeverity = severity;
        final MetaData finalMetaData = metaData;
        Bugsnag.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setSeverity(finalSeverity);
                report.getError().setMetaData(finalMetaData);
            }
        });
    }

    @Deprecated
    public static void notify(@NonNull String name, @NonNull String message, String context, @NonNull StackTraceElement[] stacktrace, Severity severity, @NonNull MetaData metaData) {
        final String finalContext = context;
        final Severity finalSeverity = severity;
        final MetaData finalMetaData = metaData;
        Bugsnag.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setSeverity(finalSeverity);
                report.getError().setMetaData(finalMetaData);
                report.getError().setContext(finalContext);
            }
        });
    }

    public static void internalClientNotify(@NonNull Throwable exception, Map<String, Object> clientData, boolean blocking, Callback callback) {
        Bugsnag.getClient().internalClientNotify(exception, clientData, blocking, callback);
    }

    public static void addToTab(String tab, String key, Object value) {
        Bugsnag.getClient().addToTab(tab, key, value);
    }

    public static void clearTab(String tabName) {
        Bugsnag.getClient().clearTab(tabName);
    }

    @NonNull
    public static MetaData getMetaData() {
        return Bugsnag.getClient().getMetaData();
    }

    public static void setMetaData(@NonNull MetaData metaData) {
        Bugsnag.getClient().setMetaData(metaData);
    }

    public static void leaveBreadcrumb(@NonNull String message) {
        Bugsnag.getClient().leaveBreadcrumb(message);
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type, @NonNull Map<String, String> metadata) {
        Bugsnag.getClient().leaveBreadcrumb(name, type, metadata);
    }

    @Deprecated
    public static void setMaxBreadcrumbs(int numBreadcrumbs) {
        Bugsnag.getClient().config.setMaxBreadcrumbs(numBreadcrumbs);
    }

    public static void clearBreadcrumbs() {
        Bugsnag.getClient().clearBreadcrumbs();
    }

    public static void enableExceptionHandler() {
        Bugsnag.getClient().enableExceptionHandler();
    }

    public static void disableExceptionHandler() {
        Bugsnag.getClient().disableExceptionHandler();
    }

    public static void setLoggingEnabled(boolean enabled) {
        Bugsnag.getClient().setLoggingEnabled(enabled);
    }

    public static void startSession() {
        Bugsnag.getClient().startSession();
    }

    @NonNull
    public static Client getClient() {
        if (client == null) {
            throw new IllegalStateException("You must call Bugsnag.init before any other Bugsnag methods");
        }
        return client;
    }
}

