/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class Breadcrumbs
implements JsonStream.Streamable {
    private static final int MAX_PAYLOAD_SIZE = 4096;
    final Queue<Breadcrumb> store = new ConcurrentLinkedQueue<Breadcrumb>();
    private final Configuration configuration;

    Breadcrumbs(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        this.pruneBreadcrumbs();
        writer.beginArray();
        for (Breadcrumb breadcrumb : this.store) {
            breadcrumb.toStream(writer);
        }
        writer.endArray();
    }

    void add(@NonNull Breadcrumb breadcrumb) {
        this.addToStore(breadcrumb);
    }

    void clear() {
        this.store.clear();
    }

    private void addToStore(@NonNull Breadcrumb breadcrumb) {
        try {
            if (breadcrumb.payloadSize() > 4096) {
                Logger.warn("Dropping breadcrumb because payload exceeds 4KB limit");
                return;
            }
            this.store.add(breadcrumb);
            this.pruneBreadcrumbs();
        }
        catch (IOException ex) {
            Logger.warn("Dropping breadcrumb because it could not be serialized", ex);
        }
    }

    private void pruneBreadcrumbs() {
        int maxBreadcrumbs = this.configuration.getMaxBreadcrumbs();
        while (this.store.size() > maxBreadcrumbs) {
            this.store.poll();
        }
    }
}

