/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Error;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notifier;
import java.io.File;
import java.io.IOException;

public class Report
implements JsonStream.Streamable {
    @Nullable
    private final File errorFile;
    @Nullable
    private Error error;
    private Notifier notifier;
    private String apiKey;

    Report(@NonNull String apiKey, @Nullable File errorFile) {
        this.error = null;
        this.errorFile = errorFile;
        this.notifier = Notifier.getInstance();
        this.apiKey = apiKey;
    }

    Report(@NonNull String apiKey, @Nullable Error error) {
        this.error = error;
        this.errorFile = null;
        this.notifier = Notifier.getInstance();
        this.apiKey = apiKey;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("apiKey").value(this.apiKey);
        writer.name("payloadVersion").value("4.0");
        writer.name("notifier").value(this.notifier);
        writer.name("events").beginArray();
        if (this.error != null) {
            writer.value(this.error);
        }
        if (this.errorFile != null) {
            writer.value(this.errorFile);
        }
        writer.endArray();
        writer.endObject();
    }

    @Nullable
    public Error getError() {
        return this.error;
    }

    public void setApiKey(@NonNull String apiKey) {
        this.apiKey = apiKey;
    }

    public void setNotifierVersion(@NonNull String version) {
        this.notifier.setVersion(version);
    }

    public void setNotifierName(@NonNull String name) {
        this.notifier.setName(name);
    }

    public void setNotifierURL(@NonNull String url) {
        this.notifier.setURL(url);
    }
}

