/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ThreadState
implements JsonStream.Streamable {
    private static final String THREAD_TYPE = "android";
    final Configuration config;
    private final Thread[] threads;
    private final Map<Thread, StackTraceElement[]> stackTraces;

    ThreadState(Configuration config) {
        this.config = config;
        this.stackTraces = Thread.getAllStackTraces();
        this.threads = this.sanitiseThreads(Thread.currentThread().getId(), this.stackTraces);
    }

    private Thread[] sanitiseThreads(long currentThreadId, Map<Thread, StackTraceElement[]> liveThreads) {
        Set<Thread> threadSet = liveThreads.keySet();
        Iterator<Thread> iterator = threadSet.iterator();
        while (iterator.hasNext()) {
            Thread thread = iterator.next();
            if (thread.getId() != currentThreadId) continue;
            iterator.remove();
        }
        Thread[] threads = threadSet.toArray(new Thread[threadSet.size()]);
        Arrays.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(@NonNull Thread lhs, @NonNull Thread rhs) {
                return Long.valueOf(lhs.getId()).compareTo(rhs.getId());
            }
        });
        return threads;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Thread thread : this.threads) {
            writer.beginObject();
            writer.name("id").value(thread.getId());
            writer.name("name").value(thread.getName());
            writer.name("type").value(THREAD_TYPE);
            StackTraceElement[] stacktrace = this.stackTraces.get(thread);
            writer.name("stacktrace").value(new Stacktrace(this.config, stacktrace));
            writer.endObject();
        }
        writer.endArray();
    }
}

