/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.BeforeRecordBreadcrumb;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.NotifyType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Configuration
extends Observable
implements Observer {
    private static final String HEADER_API_PAYLOAD_VERSION = "Bugsnag-Payload-Version";
    private static final String HEADER_API_KEY = "Bugsnag-Api-Key";
    private static final String HEADER_BUGSNAG_SENT_AT = "Bugsnag-Sent-At";
    @NonNull
    private final String apiKey;
    private String buildUuid;
    private String appVersion;
    private String context;
    private String endpoint = "https://notify.bugsnag.com";
    private String sessionEndpoint = "https://sessions.bugsnag.com";
    private String[] ignoreClasses;
    @Nullable
    private String[] notifyReleaseStages = null;
    private String[] projectPackages;
    private String releaseStage;
    private boolean sendThreads = true;
    private boolean enableExceptionHandler = true;
    private boolean persistUserBetweenSessions = false;
    private long launchCrashThresholdMs = 5000L;
    private boolean autoCaptureSessions = false;
    private boolean automaticallyCollectBreadcrumbs = true;
    @NonNull
    String defaultExceptionType = "android";
    @NonNull
    private MetaData metaData;
    private final Collection<BeforeNotify> beforeNotifyTasks = new ConcurrentLinkedQueue<BeforeNotify>();
    private final Collection<BeforeRecordBreadcrumb> beforeRecordBreadcrumbTasks = new ConcurrentLinkedQueue<BeforeRecordBreadcrumb>();
    private String codeBundleId;
    private String notifierType;

    public Configuration(@NonNull String apiKey) {
        this.apiKey = apiKey;
        this.metaData = new MetaData();
        this.metaData.addObserver(this);
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        this.notifyBugsnagObservers(NotifyType.APP);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
        this.notifyBugsnagObservers(NotifyType.CONTEXT);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getSessionEndpoint() {
        return this.sessionEndpoint;
    }

    public void setSessionEndpoint(String endpoint) {
        this.sessionEndpoint = endpoint;
    }

    public String getBuildUUID() {
        return this.buildUuid;
    }

    public void setBuildUUID(String buildUuid) {
        this.buildUuid = buildUuid;
        this.notifyBugsnagObservers(NotifyType.APP);
    }

    public String[] getFilters() {
        return this.metaData.getFilters();
    }

    public void setFilters(String[] filters) {
        this.metaData.setFilters(filters);
    }

    public String[] getIgnoreClasses() {
        return this.ignoreClasses;
    }

    public void setIgnoreClasses(String[] ignoreClasses) {
        this.ignoreClasses = ignoreClasses;
    }

    @Nullable
    public String[] getNotifyReleaseStages() {
        return this.notifyReleaseStages;
    }

    public void setNotifyReleaseStages(@Nullable String[] notifyReleaseStages) {
        this.notifyReleaseStages = notifyReleaseStages;
        this.notifyBugsnagObservers(NotifyType.RELEASE_STAGES);
    }

    public String[] getProjectPackages() {
        return this.projectPackages;
    }

    public void setProjectPackages(String[] projectPackages) {
        this.projectPackages = projectPackages;
    }

    public String getReleaseStage() {
        return this.releaseStage;
    }

    public void setReleaseStage(String releaseStage) {
        this.releaseStage = releaseStage;
        this.notifyBugsnagObservers(NotifyType.APP);
    }

    public boolean getSendThreads() {
        return this.sendThreads;
    }

    public void setSendThreads(boolean sendThreads) {
        this.sendThreads = sendThreads;
    }

    public boolean getEnableExceptionHandler() {
        return this.enableExceptionHandler;
    }

    public void setEnableExceptionHandler(boolean enableExceptionHandler) {
        this.enableExceptionHandler = enableExceptionHandler;
    }

    public boolean shouldAutoCaptureSessions() {
        return this.autoCaptureSessions;
    }

    public void setAutoCaptureSessions(boolean autoCapture) {
        this.autoCaptureSessions = autoCapture;
    }

    @NonNull
    protected MetaData getMetaData() {
        return this.metaData;
    }

    protected void setMetaData(@NonNull MetaData metaData) {
        this.metaData.deleteObserver(this);
        this.metaData = metaData == null ? new MetaData() : metaData;
        this.metaData.addObserver(this);
        this.notifyBugsnagObservers(NotifyType.META);
    }

    @NonNull
    protected Collection<BeforeNotify> getBeforeNotifyTasks() {
        return this.beforeNotifyTasks;
    }

    public boolean getPersistUserBetweenSessions() {
        return this.persistUserBetweenSessions;
    }

    public void setPersistUserBetweenSessions(boolean persistUserBetweenSessions) {
        this.persistUserBetweenSessions = persistUserBetweenSessions;
    }

    public long getLaunchCrashThresholdMs() {
        return this.launchCrashThresholdMs;
    }

    public void setLaunchCrashThresholdMs(long launchCrashThresholdMs) {
        this.launchCrashThresholdMs = launchCrashThresholdMs <= 0L ? 0L : launchCrashThresholdMs;
    }

    public boolean isAutomaticallyCollectingBreadcrumbs() {
        return this.automaticallyCollectBreadcrumbs;
    }

    public void setAutomaticallyCollectBreadcrumbs(boolean automaticallyCollectBreadcrumbs) {
        this.automaticallyCollectBreadcrumbs = automaticallyCollectBreadcrumbs;
    }

    public void setNotifierType(String notifierType) {
        this.notifierType = notifierType;
    }

    public void setCodeBundleId(String codeBundleId) {
        this.codeBundleId = codeBundleId;
    }

    String getCodeBundleId() {
        return this.codeBundleId;
    }

    String getNotifierType() {
        return this.notifierType;
    }

    Map<String, String> getErrorApiHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(HEADER_API_PAYLOAD_VERSION, "4.0");
        map.put(HEADER_API_KEY, this.apiKey);
        map.put(HEADER_BUGSNAG_SENT_AT, DateUtils.toIso8601(new Date()));
        return map;
    }

    Map<String, String> getSessionApiHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(HEADER_API_PAYLOAD_VERSION, "1.0");
        map.put(HEADER_API_KEY, this.apiKey);
        map.put(HEADER_BUGSNAG_SENT_AT, DateUtils.toIso8601(new Date()));
        return map;
    }

    protected boolean shouldNotifyForReleaseStage(String releaseStage) {
        if (this.notifyReleaseStages == null) {
            return true;
        }
        List<String> stages = Arrays.asList(this.notifyReleaseStages);
        return stages.contains(releaseStage);
    }

    protected boolean shouldIgnoreClass(String className) {
        if (this.ignoreClasses == null) {
            return false;
        }
        List<String> classes = Arrays.asList(this.ignoreClasses);
        return classes.contains(className);
    }

    protected void beforeNotify(BeforeNotify beforeNotify) {
        if (!this.beforeNotifyTasks.contains(beforeNotify)) {
            this.beforeNotifyTasks.add(beforeNotify);
        }
    }

    protected void beforeRecordBreadcrumb(BeforeRecordBreadcrumb beforeRecordBreadcrumb) {
        if (!this.beforeRecordBreadcrumbTasks.contains(beforeRecordBreadcrumb)) {
            this.beforeRecordBreadcrumbTasks.add(beforeRecordBreadcrumb);
        }
    }

    protected boolean inProject(@NonNull String className) {
        if (this.projectPackages != null) {
            for (String packageName : this.projectPackages) {
                if (packageName == null || !className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private void notifyBugsnagObservers(@NonNull NotifyType type) {
        this.setChanged();
        super.notifyObservers(type.getValue());
    }

    @Override
    public void update(Observable observable, Object arg) {
        NotifyType type;
        if (arg instanceof Integer && (type = NotifyType.fromInt((Integer)arg)) != null) {
            this.notifyBugsnagObservers(type);
        }
    }

    protected Collection<BeforeRecordBreadcrumb> getBeforeRecordBreadcrumbTasks() {
        return this.beforeRecordBreadcrumbTasks;
    }
}

