/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.os.StrictMode;
import android.support.annotation.NonNull;
import com.bugsnag.android.Async;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.NetworkException;
import com.bugsnag.android.Report;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;

class ErrorStore
extends FileStore<Error> {
    private static final String STARTUP_CRASH = "_startupcrash";
    static final Comparator<File> ERROR_REPORT_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            String lhsName = lhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            String rhsName = rhs.getName().replaceAll(ErrorStore.STARTUP_CRASH, "");
            return lhsName.compareTo(rhsName);
        }
    };

    ErrorStore(@NonNull Configuration config, @NonNull Context appContext) {
        super(config, appContext, "/bugsnag-errors/", 128, ERROR_REPORT_COMPARATOR);
    }

    void flushOnLaunch(ErrorReportApiClient errorReportApiClient) {
        List<File> crashReports = this.findLaunchCrashReports();
        if (crashReports.isEmpty() && this.config.getLaunchCrashThresholdMs() > 0L) {
            this.flushAsync(errorReportApiClient);
        } else {
            StrictMode.ThreadPolicy originalThreadPolicy = StrictMode.getThreadPolicy();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)StrictMode.ThreadPolicy.LAX);
            for (File crashReport : crashReports) {
                this.flushErrorReport(crashReport, errorReportApiClient);
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalThreadPolicy);
        }
    }

    void flushAsync(final ErrorReportApiClient errorReportApiClient) {
        if (this.storeDirectory == null) {
            return;
        }
        try {
            Async.run(new Runnable(){

                @Override
                public void run() {
                    List<File> storedFiles = ErrorStore.this.findStoredFiles();
                    if (!storedFiles.isEmpty()) {
                        Logger.info(String.format(Locale.US, "Sending %d saved error(s) to Bugsnag", storedFiles.size()));
                        for (File errorFile : storedFiles) {
                            ErrorStore.this.flushErrorReport(errorFile, errorReportApiClient);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Logger.warn("Failed to flush all on-disk errors, retaining unsent errors for later.");
        }
    }

    private void flushErrorReport(File errorFile, ErrorReportApiClient errorReportApiClient) {
        block4: {
            try {
                Report report = new Report(errorFile);
                errorReportApiClient.postReport(this.config.getEndpoint(), report, this.config.getErrorApiHeaders());
                Logger.info("Deleting sent error file " + errorFile.getName());
                if (!errorFile.delete()) {
                    errorFile.deleteOnExit();
                }
            }
            catch (NetworkException e) {
                Logger.warn("Could not send previously saved error(s) to Bugsnag, will try again later", e);
            }
            catch (Exception e) {
                Logger.warn("Problem sending unsent error from disk", e);
                if (errorFile.delete()) break block4;
                errorFile.deleteOnExit();
            }
        }
    }

    boolean isLaunchCrashReport(File file) {
        String name = file.getName();
        return name.matches("[0-9]+_startupcrash\\.json");
    }

    private List<File> findLaunchCrashReports() {
        List<File> storedFiles = this.findStoredFiles();
        ArrayList<File> launchCrashes = new ArrayList<File>();
        for (File file : storedFiles) {
            if (!this.isLaunchCrashReport(file)) continue;
            launchCrashes.add(file);
        }
        return launchCrashes;
    }

    @Override
    @NonNull
    String getFilename(Error error) {
        MetaData metaData = error.getMetaData();
        boolean isStartupCrash = metaData != null && metaData.getTab("CrashOnLaunch").containsKey("Duration (ms)");
        String suffix = isStartupCrash ? STARTUP_CRASH : "";
        return String.format(Locale.US, "%s%d%s.json", this.storeDirectory, System.currentTimeMillis(), suffix);
    }
}

