/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bugsnag.android.AppData;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.Exceptions;
import com.bugsnag.android.HandledState;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Session;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;
import java.io.IOException;

public class Error
implements JsonStream.Streamable {
    @NonNull
    final Configuration config;
    private AppData appData;
    private DeviceData deviceData;
    private Breadcrumbs breadcrumbs;
    private User user;
    private final Throwable exception;
    private Severity severity = Severity.WARNING;
    @NonNull
    private MetaData metaData = new MetaData();
    private String groupingHash;
    private String context;
    private final HandledState handledState;
    private final Session session;

    Error(@NonNull Configuration config, @NonNull Throwable exception, HandledState handledState, Severity severity, Session session) {
        this.config = config;
        this.exception = exception;
        this.handledState = handledState;
        this.severity = severity;
        this.session = session;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        MetaData mergedMetaData = MetaData.merge(this.config.getMetaData(), this.metaData);
        writer.beginObject();
        writer.name("context").value(this.getContext());
        writer.name("metaData").value(mergedMetaData);
        writer.name("severity").value(this.severity);
        writer.name("severityReason").value(this.handledState);
        writer.name("unhandled").value(this.handledState.isUnhandled());
        if (this.config.getProjectPackages() != null) {
            writer.name("projectPackages").beginArray();
            for (String projectPackage : this.config.getProjectPackages()) {
                writer.value(projectPackage);
            }
            writer.endArray();
        }
        writer.name("exceptions").value(new Exceptions(this.config, this.exception));
        writer.name("user").value(this.user);
        writer.name("app").value(this.appData);
        writer.name("device").value(this.deviceData);
        writer.name("breadcrumbs").value(this.breadcrumbs);
        writer.name("groupingHash").value(this.groupingHash);
        if (this.config.getSendThreads()) {
            writer.name("threads").value(new ThreadState(this.config));
        }
        if (this.session != null) {
            writer.name("session").beginObject();
            writer.name("id").value(this.session.getId());
            writer.name("startedAt").value(DateUtils.toISO8601(this.session.getStartedAt()));
            writer.name("events").beginObject();
            writer.name("handled").value(this.session.getHandledCount());
            writer.name("unhandled").value(this.session.getUnhandledCount());
            writer.endObject();
            writer.endObject();
        }
        writer.endObject();
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Nullable
    public String getContext() {
        if (!TextUtils.isEmpty((CharSequence)this.context)) {
            return this.context;
        }
        if (this.config.getContext() != null) {
            return this.config.getContext();
        }
        if (this.appData != null) {
            return this.appData.getActiveScreenClass();
        }
        return null;
    }

    public void setGroupingHash(String groupingHash) {
        this.groupingHash = groupingHash;
    }

    public void setSeverity(@Nullable Severity severity) {
        if (severity != null) {
            this.severity = severity;
            this.handledState.setCurrentSeverity(severity);
        }
    }

    @Nullable
    public Severity getSeverity() {
        return this.severity;
    }

    public void setUser(String id, String email, String name) {
        this.user = new User(id, email, name);
    }

    public User getUser() {
        return this.user;
    }

    public void setUserId(String id) {
        this.user = new User(this.user);
        this.user.setId(id);
    }

    public void setUserEmail(String email) {
        this.user = new User(this.user);
        this.user.setEmail(email);
    }

    public void setUserName(String name) {
        this.user = new User(this.user);
        this.user.setName(name);
    }

    public void addToTab(String tabName, String key, Object value) {
        this.metaData.addToTab(tabName, key, value);
    }

    public void clearTab(String tabName) {
        this.metaData.clearTab(tabName);
    }

    @NonNull
    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(@NonNull MetaData metaData) {
        this.metaData = metaData == null ? new MetaData() : metaData;
    }

    public String getExceptionName() {
        if (this.exception instanceof BugsnagException) {
            return ((BugsnagException)this.exception).getName();
        }
        return this.exception.getClass().getName();
    }

    public String getExceptionMessage() {
        return this.exception.getLocalizedMessage();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setDeviceId(@Nullable String id) {
        this.deviceData.id = id;
    }

    void setAppData(AppData appData) {
        this.appData = appData;
    }

    void setDeviceData(DeviceData deviceData) {
        this.deviceData = deviceData;
    }

    void setUser(User user) {
        this.user = user;
    }

    void setBreadcrumbs(Breadcrumbs breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    boolean shouldIgnoreClass() {
        return this.config.shouldIgnoreClass(this.getExceptionName());
    }

    HandledState getHandledState() {
        return this.handledState;
    }

    static class Builder {
        private final Configuration config;
        private final Throwable exception;
        private final Session session;
        private Severity severity = Severity.WARNING;
        private MetaData metaData;
        private String attributeValue;
        private String severityReasonType;

        Builder(@NonNull Configuration config, @NonNull Throwable exception, Session session) {
            this.config = config;
            this.exception = exception;
            this.severityReasonType = "userSpecifiedSeverity";
            this.session = session != null && !config.shouldAutoCaptureSessions() && session.isAutoCaptured() ? null : session;
        }

        Builder(@NonNull Configuration config, @NonNull String name, @NonNull String message, @NonNull StackTraceElement[] frames, Session session) {
            this(config, new BugsnagException(name, message, frames), session);
        }

        Builder severityReasonType(String severityReasonType) {
            this.severityReasonType = severityReasonType;
            return this;
        }

        Builder attributeValue(String value) {
            this.attributeValue = value;
            return this;
        }

        Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        Error build() {
            HandledState handledState = HandledState.newInstance(this.severityReasonType, this.severity, this.attributeValue);
            Error error = new Error(this.config, this.exception, handledState, this.severity, this.session);
            if (this.metaData != null) {
                error.setMetaData(this.metaData);
            }
            return error;
        }
    }
}

