/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.AppData;
import com.bugsnag.android.AppDataSummary;
import com.bugsnag.android.DeviceDataSummary;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.Session;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SessionTrackingPayload
implements JsonStream.Streamable {
    private final Notifier notifier;
    private final Collection<Session> sessions;
    private final DeviceDataSummary deviceDataSummary = new DeviceDataSummary();
    private final AppDataSummary appDataSummary;
    private final List<File> files;

    SessionTrackingPayload(List<File> files, AppData appDataSummary) {
        this.appDataSummary = appDataSummary;
        this.notifier = Notifier.getInstance();
        this.sessions = null;
        this.files = files;
    }

    SessionTrackingPayload(Collection<Session> sessions, AppData appDataSummary) {
        this.appDataSummary = appDataSummary;
        this.notifier = Notifier.getInstance();
        this.sessions = new ArrayList<Session>();
        this.sessions.addAll(sessions);
        this.files = null;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("notifier").value(this.notifier);
        writer.name("app").value(this.appDataSummary);
        writer.name("device").value(this.deviceDataSummary);
        writer.name("sessions").beginArray();
        if (this.sessions == null) {
            for (File file : this.files) {
                writer.value(file);
            }
        } else {
            for (Session session : this.sessions) {
                writer.value(session);
            }
        }
        writer.endArray();
        writer.endObject();
    }

    Collection<Session> getSessions() {
        return this.sessions;
    }
}

