/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.bugsnag.android.AppData;
import com.bugsnag.android.BadResponseException;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NetworkException;
import com.bugsnag.android.Session;
import com.bugsnag.android.SessionStore;
import com.bugsnag.android.SessionTrackingApiClient;
import com.bugsnag.android.SessionTrackingPayload;
import com.bugsnag.android.User;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

class SessionTracker
implements Application.ActivityLifecycleCallbacks {
    private static final String KEY_LIFECYCLE_CALLBACK = "ActivityLifecycle";
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    final Collection<Session> sessionQueue = new ConcurrentLinkedQueue<Session>();
    final Queue<Pair<String, String>> breadcrumbQueue = new ConcurrentLinkedQueue<Pair<String, String>>();
    private final Set<String> foregroundActivities = new HashSet<String>();
    private final Configuration configuration;
    private final long timeoutMs;
    private final Client client;
    private final SessionStore sessionStore;
    private final SessionTrackingApiClient apiClient;
    private final Context context;
    private final String endpoint;
    private long lastForegroundMs;
    private Long sessionStartMs;
    private Session currentSession;

    SessionTracker(Configuration configuration, Client client, SessionStore sessionStore, SessionTrackingApiClient apiClient, Context context) {
        this(configuration, client, 30000L, sessionStore, apiClient, context);
    }

    SessionTracker(Configuration configuration, Client client, long timeoutMs, SessionStore sessionStore, SessionTrackingApiClient apiClient, Context context) {
        this.configuration = configuration;
        this.client = client;
        this.timeoutMs = timeoutMs;
        this.sessionStore = sessionStore;
        this.apiClient = apiClient;
        this.context = context;
        this.endpoint = configuration.getSessionEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startNewSession(@NonNull Date date, @Nullable User user, boolean autoCaptured) {
        SessionStore sessionStore = this.sessionStore;
        synchronized (sessionStore) {
            this.sessionStartMs = date.getTime();
            Session session = new Session(UUID.randomUUID().toString(), date, user);
            session.setAutoCaptured(autoCaptured);
            if (this.configuration.shouldAutoCaptureSessions() || !autoCaptured) {
                this.sessionQueue.add(session);
                this.sessionStore.write(session);
            }
            this.currentSession = session;
        }
    }

    @Nullable
    synchronized Session getCurrentSession() {
        return this.currentSession;
    }

    synchronized void incrementUnhandledError() {
        if (this.currentSession != null) {
            this.currentSession.incrementUnhandledErrCount();
        }
    }

    synchronized void incrementHandledError() {
        if (this.currentSession != null) {
            this.currentSession.incrementHandledErrCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushStoredSessions() {
        SessionStore sessionStore = this.sessionStore;
        synchronized (sessionStore) {
            List<File> storedFiles = this.sessionStore.findStoredFiles();
            if (!storedFiles.isEmpty()) {
                AppData appData = new AppData(this.context, this.configuration, this);
                SessionTrackingPayload payload = new SessionTrackingPayload(storedFiles, appData);
                try {
                    this.apiClient.postSessionTrackingPayload(this.endpoint, payload, this.configuration.getSessionApiHeaders());
                    this.deleteStoredFiles(storedFiles);
                }
                catch (NetworkException e) {
                    Logger.info("Failed to post stored session payload");
                }
                catch (BadResponseException e) {
                    Logger.warn("Invalid session tracking payload", e);
                    this.deleteStoredFiles(storedFiles);
                }
            }
        }
    }

    private void deleteStoredFiles(Collection<File> storedFiles) {
        for (File storedFile : storedFiles) {
            storedFile.delete();
        }
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onCreate()");
    }

    public void onActivityStarted(@NonNull Activity activity) {
        String activityName = this.getActivityName(activity);
        this.leaveLifecycleBreadcrumb(activityName, "onStart()");
        this.updateForegroundTracker(activityName, true, System.currentTimeMillis());
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onResume()");
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onPause()");
    }

    public void onActivityStopped(@NonNull Activity activity) {
        String activityName = this.getActivityName(activity);
        this.leaveLifecycleBreadcrumb(activityName, "onStop()");
        this.updateForegroundTracker(activityName, false, System.currentTimeMillis());
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, Bundle outState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onSaveInstanceState()");
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onDestroy()");
    }

    private String getActivityName(@NonNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    synchronized void leaveLifecycleBreadcrumb(String activityName, String lifecycleCallback) {
        if (this.client == null) {
            this.breadcrumbQueue.add((Pair<String, String>)new Pair((Object)activityName, (Object)lifecycleCallback));
        } else {
            while (!this.breadcrumbQueue.isEmpty()) {
                Pair<String, String> pair = this.breadcrumbQueue.poll();
                this.leaveBreadcrumb((String)pair.first, (String)pair.second);
            }
            this.leaveBreadcrumb(activityName, lifecycleCallback);
        }
    }

    private void leaveBreadcrumb(String activityName, String lifecycleCallback) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(KEY_LIFECYCLE_CALLBACK, lifecycleCallback);
        this.client.leaveBreadcrumb(activityName, BreadcrumbType.NAVIGATION, metadata);
    }

    void updateForegroundTracker(String activityName, boolean inForeground, long now) {
        if (inForeground) {
            long delta = now - this.lastForegroundMs;
            if (this.foregroundActivities.isEmpty() && delta >= this.timeoutMs && this.configuration.shouldAutoCaptureSessions()) {
                User user = this.client != null ? this.client.user : null;
                this.startNewSession(new Date(now), user, true);
            }
            this.foregroundActivities.add(activityName);
        } else {
            this.foregroundActivities.remove(activityName);
            this.lastForegroundMs = now;
        }
    }

    boolean isInForeground() {
        return !this.foregroundActivities.isEmpty();
    }

    long getDurationInForeground(long now) {
        long duration = 0L;
        if (this.isInForeground() && this.sessionStartMs != null) {
            duration = now - this.sessionStartMs;
        }
        return duration > 0L ? duration : 0L;
    }
}

