/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Logger;

class ConfigFactory {
    private static final String BUGSNAG_NAMESPACE = "com.bugsnag.android";
    private static final String MF_APP_VERSION = "com.bugsnag.android.APP_VERSION";
    private static final String MF_ENDPOINT = "com.bugsnag.android.ENDPOINT";
    private static final String MF_SESSIONS_ENDPOINT = "com.bugsnag.android.SESSIONS_ENDPOINT";
    private static final String MF_RELEASE_STAGE = "com.bugsnag.android.RELEASE_STAGE";
    private static final String MF_SEND_THREADS = "com.bugsnag.android.SEND_THREADS";
    private static final String MF_ENABLE_EXCEPTION_HANDLER = "com.bugsnag.android.ENABLE_EXCEPTION_HANDLER";
    private static final String MF_PERSIST_USER_BETWEEN_SESSIONS = "com.bugsnag.android.PERSIST_USER_BETWEEN_SESSIONS";
    private static final String MF_AUTO_CAPTURE_SESSIONS = "com.bugsnag.android.AUTO_CAPTURE_SESSIONS";
    private static final String MF_API_KEY = "com.bugsnag.android.API_KEY";
    private static final String MF_DETECT_NDK_CRASHES = "com.bugsnag.android.DETECT_NDK_CRASHES";
    private static final String MF_DETECT_ANRS = "com.bugsnag.android.DETECT_ANRS";
    static final String MF_BUILD_UUID = "com.bugsnag.android.BUILD_UUID";

    ConfigFactory() {
    }

    @NonNull
    static Configuration createNewConfiguration(@NonNull Context androidContext, String apiKey, boolean enableExceptionHandler) {
        Context appContext = androidContext.getApplicationContext();
        boolean loadFromManifest = TextUtils.isEmpty((CharSequence)apiKey);
        if (loadFromManifest) {
            try {
                PackageManager packageManager = appContext.getPackageManager();
                String packageName = appContext.getPackageName();
                ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 128);
                Bundle data = ai.metaData;
                apiKey = data.getString(MF_API_KEY);
            }
            catch (Exception ignore) {
                Logger.warn("Bugsnag is unable to read api key from manifest.");
            }
        }
        if (apiKey == null) {
            throw new NullPointerException("You must provide a Bugsnag API key");
        }
        Configuration newConfig = new Configuration(apiKey);
        newConfig.setEnableExceptionHandler(enableExceptionHandler);
        if (loadFromManifest) {
            try {
                PackageManager packageManager = appContext.getPackageManager();
                String packageName = appContext.getPackageName();
                ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 128);
                Bundle data = ai.metaData;
                ConfigFactory.populateConfigFromManifest(newConfig, data);
            }
            catch (Exception ignore) {
                Logger.warn("Bugsnag is unable to read config from manifest.");
            }
        }
        return newConfig;
    }

    static void populateConfigFromManifest(@NonNull Configuration config, @NonNull Bundle data) {
        config.setBuildUUID(data.getString(MF_BUILD_UUID));
        config.setAppVersion(data.getString(MF_APP_VERSION));
        config.setReleaseStage(data.getString(MF_RELEASE_STAGE));
        if (data.containsKey(MF_ENDPOINT)) {
            String endpoint = data.getString(MF_ENDPOINT);
            String sessionEndpoint = data.getString(MF_SESSIONS_ENDPOINT);
            config.setEndpoints(endpoint, sessionEndpoint);
        }
        config.setSendThreads(data.getBoolean(MF_SEND_THREADS, true));
        config.setPersistUserBetweenSessions(data.getBoolean(MF_PERSIST_USER_BETWEEN_SESSIONS, false));
        if (data.containsKey(MF_DETECT_NDK_CRASHES)) {
            config.setDetectNdkCrashes(data.getBoolean(MF_DETECT_NDK_CRASHES));
        }
        if (data.containsKey(MF_DETECT_ANRS)) {
            config.setDetectAnrs(data.getBoolean(MF_DETECT_ANRS));
        }
        if (data.containsKey(MF_AUTO_CAPTURE_SESSIONS)) {
            config.setAutoCaptureSessions(data.getBoolean(MF_AUTO_CAPTURE_SESSIONS));
        }
        config.setEnableExceptionHandler(data.getBoolean(MF_ENABLE_EXCEPTION_HANDLER, true));
    }
}

