/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;

class Exceptions
implements JsonStream.Streamable {
    private final Throwable exception;
    private String exceptionType;
    private String[] projectPackages;

    Exceptions(Configuration config, Throwable exception) {
        this.exception = exception;
        this.exceptionType = "android";
        this.projectPackages = config.getProjectPackages();
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Throwable currentEx = this.exception; currentEx != null; currentEx = currentEx.getCause()) {
            if (currentEx instanceof JsonStream.Streamable) {
                ((JsonStream.Streamable)((Object)currentEx)).toStream(writer);
                continue;
            }
            String exceptionName = this.getExceptionName(currentEx);
            String localizedMessage = currentEx.getLocalizedMessage();
            StackTraceElement[] stackTrace = currentEx.getStackTrace();
            this.exceptionToStream(writer, exceptionName, localizedMessage, stackTrace);
        }
        writer.endArray();
    }

    Throwable getException() {
        return this.exception;
    }

    String getExceptionType() {
        return this.exceptionType;
    }

    void setExceptionType(@NonNull String type) {
        this.exceptionType = type;
    }

    String[] getProjectPackages() {
        return this.projectPackages;
    }

    void setProjectPackages(String[] projectPackages) {
        this.projectPackages = projectPackages;
    }

    private String getExceptionName(@NonNull Throwable throwable) {
        if (throwable instanceof BugsnagException) {
            return ((BugsnagException)throwable).getName();
        }
        return throwable.getClass().getName();
    }

    private void exceptionToStream(@NonNull JsonStream writer, String name, String message, StackTraceElement[] frames) throws IOException {
        writer.beginObject();
        writer.name("errorClass").value(name);
        writer.name("message").value(message);
        writer.name("type").value(this.exceptionType);
        Stacktrace stacktrace = new Stacktrace(frames, this.projectPackages);
        writer.name("stacktrace").value(stacktrace);
        writer.endObject();
    }
}

