/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.Logger;
import java.util.HashMap;
import java.util.Map;

public class EventReceiver
extends BroadcastReceiver {
    private static final String INTENT_ACTION_KEY = "Intent Action";
    @NonNull
    private static final Map<String, BreadcrumbType> actions = EventReceiver.buildActions();
    private final Client client;

    public EventReceiver(@NonNull Client client) {
        this.client = client;
    }

    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        try {
            BreadcrumbType type;
            HashMap<String, String> meta = new HashMap<String, String>();
            String fullAction = intent.getAction();
            String shortAction = EventReceiver.shortenActionNameIfNeeded(intent.getAction());
            meta.put(INTENT_ACTION_KEY, fullAction);
            Bundle extras = intent.getExtras();
            if (extras != null) {
                for (String key : extras.keySet()) {
                    String val = extras.get(key).toString();
                    if (EventReceiver.isAndroidKey(key)) {
                        meta.put("Extra", String.format("%s: %s", shortAction, val));
                        continue;
                    }
                    meta.put(key, val);
                }
            }
            BreadcrumbType breadcrumbType = type = actions.containsKey(fullAction) ? actions.get(fullAction) : BreadcrumbType.LOG;
            if (this.client.getConfig().isAutomaticallyCollectingBreadcrumbs()) {
                this.client.leaveBreadcrumb(shortAction, type, meta);
            }
        }
        catch (Exception ex) {
            Logger.warn("Failed to leave breadcrumb in EventReceiver: " + ex.getMessage());
        }
    }

    static boolean isAndroidKey(@NonNull String actionName) {
        return actionName.startsWith("android.");
    }

    @NonNull
    static String shortenActionNameIfNeeded(@NonNull String action) {
        if (EventReceiver.isAndroidKey(action)) {
            return action.substring(action.lastIndexOf(".") + 1);
        }
        return action;
    }

    @NonNull
    private static Map<String, BreadcrumbType> buildActions() {
        HashMap<String, BreadcrumbType> actions = new HashMap<String, BreadcrumbType>();
        actions.put("android.appwidget.action.APPWIDGET_DELETED", BreadcrumbType.USER);
        actions.put("android.appwidget.action.APPWIDGET_DISABLED", BreadcrumbType.USER);
        actions.put("android.appwidget.action.APPWIDGET_ENABLED", BreadcrumbType.USER);
        actions.put("android.appwidget.action.APPWIDGET_HOST_RESTORED", BreadcrumbType.STATE);
        actions.put("android.appwidget.action.APPWIDGET_RESTORED", BreadcrumbType.STATE);
        actions.put("android.appwidget.action.APPWIDGET_UPDATE", BreadcrumbType.STATE);
        actions.put("android.appwidget.action.APPWIDGET_UPDATE_OPTIONS", BreadcrumbType.STATE);
        actions.put("android.intent.action.ACTION_POWER_CONNECTED", BreadcrumbType.STATE);
        actions.put("android.intent.action.ACTION_POWER_DISCONNECTED", BreadcrumbType.STATE);
        actions.put("android.intent.action.ACTION_SHUTDOWN", BreadcrumbType.STATE);
        actions.put("android.intent.action.AIRPLANE_MODE", BreadcrumbType.STATE);
        actions.put("android.intent.action.BATTERY_LOW", BreadcrumbType.STATE);
        actions.put("android.intent.action.BATTERY_OKAY", BreadcrumbType.STATE);
        actions.put("android.intent.action.BOOT_COMPLETED", BreadcrumbType.STATE);
        actions.put("android.intent.action.CAMERA_BUTTON", BreadcrumbType.USER);
        actions.put("android.intent.action.CLOSE_SYSTEM_DIALOGS", BreadcrumbType.USER);
        actions.put("android.intent.action.CONFIGURATION_CHANGED", BreadcrumbType.STATE);
        actions.put("android.intent.action.CONTENT_CHANGED", BreadcrumbType.STATE);
        actions.put("android.intent.action.DATE_CHANGED", BreadcrumbType.STATE);
        actions.put("android.intent.action.DEVICE_STORAGE_LOW", BreadcrumbType.STATE);
        actions.put("android.intent.action.DEVICE_STORAGE_OK", BreadcrumbType.STATE);
        actions.put("android.intent.action.DOCK_EVENT", BreadcrumbType.USER);
        actions.put("android.intent.action.DREAMING_STARTED", BreadcrumbType.NAVIGATION);
        actions.put("android.intent.action.DREAMING_STOPPED", BreadcrumbType.NAVIGATION);
        actions.put("android.intent.action.INPUT_METHOD_CHANGED", BreadcrumbType.STATE);
        actions.put("android.intent.action.LOCALE_CHANGED", BreadcrumbType.STATE);
        actions.put("android.intent.action.REBOOT", BreadcrumbType.STATE);
        actions.put("android.intent.action.SCREEN_OFF", BreadcrumbType.STATE);
        actions.put("android.intent.action.SCREEN_ON", BreadcrumbType.STATE);
        actions.put("android.intent.action.TIMEZONE_CHANGED", BreadcrumbType.STATE);
        actions.put("android.intent.action.TIME_SET", BreadcrumbType.STATE);
        actions.put("android.media.RINGER_MODE_CHANGED", BreadcrumbType.STATE);
        actions.put("android.os.action.DEVICE_IDLE_MODE_CHANGED", BreadcrumbType.STATE);
        actions.put("android.os.action.POWER_SAVE_MODE_CHANGED", BreadcrumbType.STATE);
        return actions;
    }

    @NonNull
    public static IntentFilter getIntentFilter() {
        IntentFilter filter = new IntentFilter();
        for (String action : actions.keySet()) {
            filter.addAction(action);
        }
        return filter;
    }
}

