/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Async;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.DeliveryFailureException;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MapUtils;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.Session;
import com.bugsnag.android.SessionStore;
import com.bugsnag.android.SessionTrackingPayload;
import com.bugsnag.android.User;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class SessionTracker
extends Observable
implements Application.ActivityLifecycleCallbacks {
    private static final String KEY_LIFECYCLE_CALLBACK = "ActivityLifecycle";
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private final Collection<String> foregroundActivities = new ConcurrentLinkedQueue<String>();
    private final long timeoutMs;
    final Configuration configuration;
    final Client client;
    final SessionStore sessionStore;
    private AtomicLong lastExitedForegroundMs = new AtomicLong(0L);
    private AtomicLong lastEnteredForegroundMs = new AtomicLong(0L);
    private AtomicReference<Session> currentSession = new AtomicReference();
    private Semaphore flushingRequest = new Semaphore(1);

    SessionTracker(Configuration configuration, Client client, SessionStore sessionStore) {
        this(configuration, client, 30000L, sessionStore);
    }

    SessionTracker(Configuration configuration, Client client, long timeoutMs, SessionStore sessionStore) {
        this.configuration = configuration;
        this.client = client;
        this.timeoutMs = timeoutMs;
        this.sessionStore = sessionStore;
    }

    @Nullable
    Session startNewSession(@NonNull Date date, @Nullable User user, boolean autoCaptured) {
        if (this.configuration.getSessionEndpoint() == null) {
            Logger.warn("The session tracking endpoint has not been set. Session tracking is disabled");
            return null;
        }
        Session session = new Session(UUID.randomUUID().toString(), date, user, autoCaptured);
        this.currentSession.set(session);
        this.trackSessionIfNeeded(session);
        return session;
    }

    private void trackSessionIfNeeded(final Session session) {
        boolean notifyForRelease = this.configuration.shouldNotifyForReleaseStage(this.getReleaseStage());
        if (notifyForRelease && (this.configuration.getAutoCaptureSessions() || !session.isAutoCaptured()) && session.isTracked().compareAndSet(false, true)) {
            try {
                String endpoint = this.configuration.getSessionEndpoint();
                Async.run(new Runnable(){

                    @Override
                    public void run() {
                        SessionTracker.this.flushStoredSessions();
                        SessionTrackingPayload payload = new SessionTrackingPayload(session, null, SessionTracker.this.client.appData, SessionTracker.this.client.deviceData);
                        try {
                            SessionTracker.this.configuration.getDelivery().deliver(payload, SessionTracker.this.configuration);
                        }
                        catch (DeliveryFailureException exception) {
                            Logger.warn("Storing session payload for future delivery", exception);
                            SessionTracker.this.sessionStore.write(session);
                        }
                        catch (Exception exception) {
                            Logger.warn("Dropping invalid session tracking payload", exception);
                        }
                    }
                });
            }
            catch (RejectedExecutionException exception) {
                this.sessionStore.write(session);
            }
            this.setChanged();
            String startedAt = DateUtils.toIso8601(session.getStartedAt());
            this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.START_SESSION, Arrays.asList(session.getId(), startedAt)));
        }
    }

    void onAutoCaptureEnabled() {
        Session session = this.currentSession.get();
        if (session != null && !this.foregroundActivities.isEmpty()) {
            this.trackSessionIfNeeded(session);
        }
    }

    private String getReleaseStage() {
        return MapUtils.getStringFromMap("releaseStage", this.client.appData.getAppDataSummary());
    }

    @Nullable
    Session getCurrentSession() {
        return this.currentSession.get();
    }

    void incrementUnhandledError() {
        Session session = this.currentSession.get();
        if (session != null) {
            session.incrementUnhandledErrCount();
        }
    }

    void incrementHandledError() {
        Session session = this.currentSession.get();
        if (session != null) {
            session.incrementHandledErrCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushStoredSessions() {
        if (this.flushingRequest.tryAcquire(1)) {
            try {
                List<File> storedFiles = this.sessionStore.findStoredFiles();
                if (!storedFiles.isEmpty()) {
                    SessionTrackingPayload payload = new SessionTrackingPayload(null, storedFiles, this.client.appData, this.client.deviceData);
                    try {
                        this.configuration.getDelivery().deliver(payload, this.configuration);
                        this.sessionStore.deleteStoredFiles(storedFiles);
                    }
                    catch (DeliveryFailureException exception) {
                        this.sessionStore.cancelQueuedFiles(storedFiles);
                        Logger.warn("Leaving session payload for future delivery", exception);
                    }
                    catch (Exception exception) {
                        Logger.warn("Deleting invalid session tracking payload", exception);
                        this.sessionStore.deleteStoredFiles(storedFiles);
                    }
                }
            }
            finally {
                this.flushingRequest.release(1);
            }
        }
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onCreate()");
    }

    public void onActivityStarted(@NonNull Activity activity) {
        String activityName = this.getActivityName(activity);
        this.leaveLifecycleBreadcrumb(activityName, "onStart()");
        this.updateForegroundTracker(activityName, true, System.currentTimeMillis());
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onResume()");
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onPause()");
    }

    public void onActivityStopped(@NonNull Activity activity) {
        String activityName = this.getActivityName(activity);
        this.leaveLifecycleBreadcrumb(activityName, "onStop()");
        this.updateForegroundTracker(activityName, false, System.currentTimeMillis());
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, Bundle outState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onSaveInstanceState()");
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onDestroy()");
    }

    private String getActivityName(@NonNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    void leaveLifecycleBreadcrumb(String activityName, String lifecycleCallback) {
        this.leaveBreadcrumb(activityName, lifecycleCallback);
    }

    private void leaveBreadcrumb(String activityName, String lifecycleCallback) {
        if (this.configuration.isAutomaticallyCollectingBreadcrumbs()) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(KEY_LIFECYCLE_CALLBACK, lifecycleCallback);
            try {
                this.client.leaveBreadcrumb(activityName, BreadcrumbType.NAVIGATION, metadata);
            }
            catch (Exception ex) {
                Logger.warn("Failed to leave breadcrumb in SessionTracker: " + ex.getMessage());
            }
        }
    }

    void startFirstSession(Activity activity) {
        Session session = this.currentSession.get();
        if (session == null) {
            long nowMs = System.currentTimeMillis();
            this.lastEnteredForegroundMs.set(nowMs);
            this.startNewSession(new Date(nowMs), this.client.getUser(), true);
            this.foregroundActivities.add(this.getActivityName(activity));
        }
    }

    void updateForegroundTracker(String activityName, boolean activityStarting, long nowMs) {
        if (activityStarting) {
            long noActivityRunningForMs = nowMs - this.lastExitedForegroundMs.get();
            if (this.foregroundActivities.isEmpty()) {
                this.lastEnteredForegroundMs.set(nowMs);
                if (noActivityRunningForMs >= this.timeoutMs && this.configuration.getAutoCaptureSessions()) {
                    this.startNewSession(new Date(nowMs), this.client.getUser(), true);
                }
            }
            this.foregroundActivities.add(activityName);
        } else {
            this.foregroundActivities.remove(activityName);
            if (this.foregroundActivities.isEmpty()) {
                this.lastExitedForegroundMs.set(nowMs);
            }
        }
        this.setChanged();
        this.notifyObservers(new NativeInterface.Message(NativeInterface.MessageType.UPDATE_IN_FOREGROUND, Arrays.asList(!this.foregroundActivities.isEmpty(), this.getContextActivity())));
    }

    boolean isInForeground() {
        return !this.foregroundActivities.isEmpty();
    }

    long getDurationInForegroundMs(long nowMs) {
        long durationMs = 0L;
        long sessionStartTimeMs = this.lastEnteredForegroundMs.get();
        if (this.isInForeground() && sessionStartTimeMs != 0L) {
            durationMs = nowMs - sessionStartTimeMs;
        }
        return durationMs > 0L ? durationMs : 0L;
    }

    @Nullable
    String getContextActivity() {
        if (this.foregroundActivities.isEmpty()) {
            return null;
        }
        int size = this.foregroundActivities.size();
        String[] activities = this.foregroundActivities.toArray(new String[size]);
        return activities[size - 1];
    }
}

