/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class LifecycleBreadcrumbLogger
implements Application.ActivityLifecycleCallbacks {
    private static final String KEY_LIFECYCLE_CALLBACK = "ActivityLifecycle";
    final Queue<Pair<String, String>> queue = new ConcurrentLinkedQueue<Pair<String, String>>();
    private final Client client;

    LifecycleBreadcrumbLogger(Client client) {
        this.client = client;
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onCreate()");
    }

    public void onActivityStarted(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onStart()");
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onResume()");
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onPause()");
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onStop()");
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, Bundle outState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onSaveInstanceState()");
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onDestroy()");
    }

    private String getActivityName(@NonNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    void leaveLifecycleBreadcrumb(String activityName, String lifecycleCallback) {
        if (this.client == null) {
            this.queue.add((Pair<String, String>)new Pair((Object)activityName, (Object)lifecycleCallback));
        } else {
            while (!this.queue.isEmpty()) {
                Pair<String, String> pair = this.queue.poll();
                this.leaveBreadcrumb((String)pair.first, (String)pair.second);
            }
            this.leaveBreadcrumb(activityName, lifecycleCallback);
        }
    }

    private void leaveBreadcrumb(String activityName, String lifecycleCallback) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(KEY_LIFECYCLE_CALLBACK, lifecycleCallback);
        this.client.leaveBreadcrumb(activityName, BreadcrumbType.NAVIGATION, metadata);
    }
}

