/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Report;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

class DefaultHttpClient
implements ErrorReportApiClient {
    private final ConnectivityManager connectivityManager;

    DefaultHttpClient(ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postReport(String urlString, Report report) throws ErrorReportApiClient.NetworkException, ErrorReportApiClient.BadResponseException {
        if (!this.hasNetworkConnection()) {
            throw new ErrorReportApiClient.NetworkException(urlString, new RuntimeException("No network connection available"));
        }
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(0);
            conn.addRequestProperty("Content-Type", "application/json");
            OutputStream out = null;
            try {
                out = conn.getOutputStream();
                JsonStream stream = new JsonStream(new OutputStreamWriter(out));
                report.toStream(stream);
                stream.close();
            }
            finally {
                IOUtils.closeQuietly(out);
            }
            int status = conn.getResponseCode();
            if (status / 100 != 2) {
                throw new ErrorReportApiClient.BadResponseException(urlString, status);
            }
        }
        catch (IOException e) {
            try {
                throw new ErrorReportApiClient.NetworkException(urlString, e);
            }
            catch (Throwable throwable) {
                IOUtils.close(conn);
                throw throwable;
            }
        }
        IOUtils.close(conn);
    }

    private boolean hasNetworkConnection() {
        NetworkInfo activeNetworkInfo = this.connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }
}

