/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Bugsnag;
import java.util.HashMap;

class LifecycleBreadcrumbLogger
implements Application.ActivityLifecycleCallbacks {
    private static final String KEY_LIFECYCLE_CALLBACK = "ActivityLifecycle";

    LifecycleBreadcrumbLogger() {
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
        this.leaveLifecycleBreadcrumb(activity, "onCreate()");
    }

    public void onActivityStarted(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(activity, "onStart()");
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(activity, "onResume()");
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(activity, "onPause()");
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(activity, "onStop()");
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, Bundle outState) {
        this.leaveLifecycleBreadcrumb(activity, "onSaveInstanceState()");
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(activity, "onDestroy()");
    }

    private void leaveLifecycleBreadcrumb(@NonNull Activity activity, String lifecycleCallback) {
        String activityName = activity.getClass().getSimpleName();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(KEY_LIFECYCLE_CALLBACK, lifecycleCallback);
        Bugsnag.leaveBreadcrumb(activityName, BreadcrumbType.NAVIGATION, metadata);
    }
}

