/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.MetaData;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Configuration {
    static final String DEFAULT_ENDPOINT = "https://notify.bugsnag.com";
    private final String apiKey;
    private String buildUUID;
    private String appVersion;
    private String context;
    private String endpoint = "https://notify.bugsnag.com";
    private String[] filters = new String[]{"password"};
    private String[] ignoreClasses;
    private String[] notifyReleaseStages = null;
    private String[] projectPackages;
    private String releaseStage;
    private boolean sendThreads = true;
    private boolean enableExceptionHandler = true;
    private boolean persistUserBetweenSessions = false;
    private MetaData metaData = new MetaData();
    private final Collection<BeforeNotify> beforeNotifyTasks = new LinkedList<BeforeNotify>();

    public Configuration(@NonNull String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getBuildUUID() {
        return this.buildUUID;
    }

    public void setBuildUUID(String buildUUID) {
        this.buildUUID = buildUUID;
    }

    public String[] getFilters() {
        return this.filters;
    }

    public void setFilters(String[] filters) {
        this.filters = filters;
    }

    public String[] getIgnoreClasses() {
        return this.ignoreClasses;
    }

    public void setIgnoreClasses(String[] ignoreClasses) {
        this.ignoreClasses = ignoreClasses;
    }

    public String[] getNotifyReleaseStages() {
        return this.notifyReleaseStages;
    }

    public void setNotifyReleaseStages(String[] notifyReleaseStages) {
        this.notifyReleaseStages = notifyReleaseStages;
    }

    public String[] getProjectPackages() {
        return this.projectPackages;
    }

    public void setProjectPackages(String[] projectPackages) {
        this.projectPackages = projectPackages;
    }

    public String getReleaseStage() {
        return this.releaseStage;
    }

    public void setReleaseStage(String releaseStage) {
        this.releaseStage = releaseStage;
    }

    public boolean getSendThreads() {
        return this.sendThreads;
    }

    public void setSendThreads(boolean sendThreads) {
        this.sendThreads = sendThreads;
    }

    public boolean getEnableExceptionHandler() {
        return this.enableExceptionHandler;
    }

    public void setEnableExceptionHandler(boolean enableExceptionHandler) {
        this.enableExceptionHandler = enableExceptionHandler;
    }

    protected MetaData getMetaData() {
        return this.metaData;
    }

    protected void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    protected Collection<BeforeNotify> getBeforeNotifyTasks() {
        return this.beforeNotifyTasks;
    }

    public boolean getPersistUserBetweenSessions() {
        return this.persistUserBetweenSessions;
    }

    public void setPersistUserBetweenSessions(boolean persistUserBetweenSessions) {
        this.persistUserBetweenSessions = persistUserBetweenSessions;
    }

    protected boolean shouldNotifyForReleaseStage(String releaseStage) {
        if (this.notifyReleaseStages == null) {
            return true;
        }
        List<String> stages = Arrays.asList(this.notifyReleaseStages);
        return stages.contains(releaseStage);
    }

    protected boolean shouldIgnoreClass(String className) {
        if (this.ignoreClasses == null) {
            return false;
        }
        List<String> classes = Arrays.asList(this.ignoreClasses);
        return classes.contains(className);
    }

    protected void beforeNotify(BeforeNotify beforeNotify) {
        this.beforeNotifyTasks.add(beforeNotify);
    }

    protected boolean inProject(String className) {
        if (this.projectPackages != null) {
            for (String packageName : this.projectPackages) {
                if (packageName == null || !className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }
}

