/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Callback;
import com.bugsnag.android.Client;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Report;
import com.bugsnag.android.Severity;
import java.util.Map;

public final class Bugsnag {
    private static Client client;

    private Bugsnag() {
    }

    public static Client init(Context androidContext) {
        client = new Client(androidContext);
        return client;
    }

    public static Client init(Context androidContext, String apiKey) {
        client = new Client(androidContext, apiKey);
        return client;
    }

    public static Client init(Context androidContext, String apiKey, boolean enableExceptionHandler) {
        client = new Client(androidContext, apiKey, enableExceptionHandler);
        return client;
    }

    public static Client init(Context androidContext, Configuration config) {
        client = new Client(androidContext, config);
        return client;
    }

    public static void setAppVersion(String appVersion) {
        Bugsnag.getClient().setAppVersion(appVersion);
    }

    public String getContext() {
        return Bugsnag.getClient().getContext();
    }

    public static void setContext(String context) {
        Bugsnag.getClient().setContext(context);
    }

    @Deprecated
    public static void setEndpoint(String endpoint) {
        Bugsnag.getClient().setEndpoint(endpoint);
    }

    public static void setBuildUUID(String buildUUID) {
        Bugsnag.getClient().setBuildUUID(buildUUID);
    }

    public static void setFilters(String ... filters) {
        Bugsnag.getClient().setFilters(filters);
    }

    public static void setIgnoreClasses(String ... ignoreClasses) {
        Bugsnag.getClient().setIgnoreClasses(ignoreClasses);
    }

    public static void setNotifyReleaseStages(String ... notifyReleaseStages) {
        Bugsnag.getClient().setNotifyReleaseStages(notifyReleaseStages);
    }

    public static void setProjectPackages(String ... projectPackages) {
        Bugsnag.getClient().setProjectPackages(projectPackages);
    }

    public static void setReleaseStage(String releaseStage) {
        Bugsnag.getClient().setReleaseStage(releaseStage);
    }

    public static void setSendThreads(boolean sendThreads) {
        Bugsnag.getClient().setSendThreads(sendThreads);
    }

    public static void setUser(String id, String email, String name) {
        Bugsnag.getClient().setUser(id, email, name);
    }

    public void clearUser() {
        Bugsnag.getClient().clearUser();
    }

    public static void setUserId(String id) {
        Bugsnag.getClient().setUserId(id);
    }

    public static void setUserEmail(String email) {
        Bugsnag.getClient().setUserEmail(email);
    }

    public static void setUserName(String name) {
        Bugsnag.getClient().setUserName(name);
    }

    public static void beforeNotify(BeforeNotify beforeNotify) {
        Bugsnag.getClient().beforeNotify(beforeNotify);
    }

    public static void notify(Throwable exception) {
        Bugsnag.getClient().notify(exception);
    }

    public static void notify(Throwable exception, Callback callback) {
        Bugsnag.getClient().notify(exception, callback);
    }

    public static void notify(String name, String message, StackTraceElement[] stacktrace, Callback callback) {
        Bugsnag.getClient().notify(name, message, stacktrace, callback);
    }

    public static void notify(Throwable exception, Severity severity) {
        Bugsnag.getClient().notify(exception, severity);
    }

    public static void notify(Throwable exception, final MetaData metaData) {
        Bugsnag.getClient().notify(exception, new Callback(){

            @Override
            public void beforeNotify(Report report) {
                report.getError().setMetaData(metaData);
            }
        });
    }

    @Deprecated
    public static void notify(Throwable exception, final Severity severity, final MetaData metaData) {
        Bugsnag.getClient().notify(exception, new Callback(){

            @Override
            public void beforeNotify(Report report) {
                report.getError().setSeverity(severity);
                report.getError().setMetaData(metaData);
            }
        });
    }

    @Deprecated
    public static void notify(String name, String message, StackTraceElement[] stacktrace, Severity severity, MetaData metaData) {
        final Severity finalSeverity = severity;
        final MetaData finalMetaData = metaData;
        Bugsnag.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(Report report) {
                report.getError().setSeverity(finalSeverity);
                report.getError().setMetaData(finalMetaData);
            }
        });
    }

    @Deprecated
    public static void notify(String name, String message, String context, StackTraceElement[] stacktrace, Severity severity, MetaData metaData) {
        final String finalContext = context;
        final Severity finalSeverity = severity;
        final MetaData finalMetaData = metaData;
        Bugsnag.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(Report report) {
                report.getError().setSeverity(finalSeverity);
                report.getError().setMetaData(finalMetaData);
                report.getError().setContext(finalContext);
            }
        });
    }

    public static void addToTab(String tab, String key, Object value) {
        Bugsnag.getClient().addToTab(tab, key, value);
    }

    public static void clearTab(String tabName) {
        Bugsnag.getClient().clearTab(tabName);
    }

    public static MetaData getMetaData() {
        return Bugsnag.getClient().getMetaData();
    }

    public static void setMetaData(MetaData metaData) {
        Bugsnag.getClient().setMetaData(metaData);
    }

    public static void leaveBreadcrumb(String message) {
        Bugsnag.getClient().leaveBreadcrumb(message);
    }

    public static void leaveBreadcrumb(String name, BreadcrumbType type, Map<String, String> metadata) {
        Bugsnag.getClient().leaveBreadcrumb(name, type, metadata);
    }

    public static void setMaxBreadcrumbs(int numBreadcrumbs) {
        Bugsnag.getClient().setMaxBreadcrumbs(numBreadcrumbs);
    }

    public static void clearBreadcrumbs() {
        Bugsnag.getClient().clearBreadcrumbs();
    }

    public static void enableExceptionHandler() {
        Bugsnag.getClient().enableExceptionHandler();
    }

    public static void disableExceptionHandler() {
        Bugsnag.getClient().disableExceptionHandler();
    }

    public static Client getClient() {
        if (client == null) {
            throw new IllegalStateException("You must call Bugsnag.init before any other Bugsnag methods");
        }
        return client;
    }
}

