/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;

class AppData
implements JsonStream.Streamable {
    private final Configuration config;
    private final String packageName;
    private final String appName;
    private final Integer versionCode;
    private final String versionName;
    private final String guessedReleaseStage;

    AppData(@NonNull Context appContext, @NonNull Configuration config) {
        this.config = config;
        this.packageName = AppData.getPackageName(appContext);
        this.appName = AppData.getAppName(appContext);
        this.versionCode = AppData.getVersionCode(appContext);
        this.versionName = AppData.getVersionName(appContext);
        this.guessedReleaseStage = AppData.guessReleaseStage(appContext);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("id").value(this.packageName);
        writer.name("name").value(this.appName);
        writer.name("packageName").value(this.packageName);
        writer.name("versionName").value(this.versionName);
        writer.name("versionCode").value(this.versionCode);
        writer.name("buildUUID").value(this.config.buildUUID);
        writer.name("version").value(this.getAppVersion());
        writer.name("releaseStage").value(this.getReleaseStage());
        writer.endObject();
    }

    @NonNull
    public String getReleaseStage() {
        if (this.config.releaseStage != null) {
            return this.config.releaseStage;
        }
        return this.guessedReleaseStage;
    }

    @Nullable
    public String getAppVersion() {
        if (this.config.appVersion != null) {
            return this.config.appVersion;
        }
        return this.versionName;
    }

    @NonNull
    private static String getPackageName(Context appContext) {
        return appContext.getPackageName();
    }

    @Nullable
    private static String getAppName(Context appContext) {
        try {
            PackageManager packageManager = appContext.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(appContext.getPackageName(), 0);
            return (String)packageManager.getApplicationLabel(appInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get app name");
            return null;
        }
    }

    @Nullable
    private static Integer getVersionCode(Context appContext) {
        try {
            return appContext.getPackageManager().getPackageInfo((String)appContext.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get versionCode");
            return null;
        }
    }

    @Nullable
    private static String getVersionName(Context appContext) {
        try {
            return appContext.getPackageManager().getPackageInfo((String)appContext.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get versionName");
            return null;
        }
    }

    @NonNull
    private static String guessReleaseStage(Context appContext) {
        try {
            int appFlags = appContext.getPackageManager().getApplicationInfo((String)appContext.getPackageName(), (int)0).flags;
            if ((appFlags & 2) != 0) {
                return "development";
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get releaseStage");
        }
        return "production";
    }
}

