/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.JsonStream;
import java.io.IOException;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class Breadcrumbs
implements JsonStream.Streamable {
    private static final int DEFAULT_MAX_SIZE = 20;
    private final Queue<Breadcrumb> store = new ConcurrentLinkedQueue<Breadcrumb>();
    private int maxSize = 20;

    Breadcrumbs() {
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Breadcrumb breadcrumb : this.store) {
            writer.beginArray();
            writer.value(breadcrumb.timestamp);
            writer.value(breadcrumb.message);
            writer.endArray();
        }
        writer.endArray();
    }

    void add(@NonNull String message) {
        if (this.store.size() >= this.maxSize) {
            this.store.poll();
        }
        this.store.add(new Breadcrumb(message));
    }

    void clear() {
        this.store.clear();
    }

    void setSize(int size) {
        if (size > this.store.size()) {
            this.maxSize = size;
        } else {
            while (this.store.size() > size) {
                this.store.poll();
            }
        }
    }

    private static class Breadcrumb {
        private static final int MAX_MESSAGE_LENGTH = 140;
        final String timestamp = DateUtils.toISO8601(new Date());
        final String message;

        Breadcrumb(@NonNull String message) {
            this.message = message.substring(0, Math.min(message.length(), 140));
        }
    }
}

