/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.HttpClient;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notifier;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

class Notification
implements JsonStream.Streamable {
    private final Configuration config;
    private final Collection<Error> errors;
    private final Collection<File> errorFiles;

    Notification(@NonNull Configuration config) {
        this.config = config;
        this.errors = new LinkedList<Error>();
        this.errorFiles = new LinkedList<File>();
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("apiKey").value(this.config.apiKey);
        writer.name("notifier").value(Notifier.getInstance());
        writer.name("events").beginArray();
        for (Error error : this.errors) {
            writer.value(error);
        }
        for (File errorFile : this.errorFiles) {
            writer.value(errorFile);
        }
        writer.endArray();
        writer.endObject();
    }

    void addError(@NonNull Error error) {
        this.errors.add(error);
    }

    void addError(@NonNull File errorFile) {
        this.errorFiles.add(errorFile);
    }

    int deliver() throws HttpClient.NetworkException, HttpClient.BadResponseException {
        HttpClient.post(this.config.getNotifyEndpoint(), this);
        return this.errors.size() + this.errorFiles.size();
    }
}

