/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.AppData;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.HttpClient$BadResponseException;
import com.bugsnag.android.HttpClient$NetworkException;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notifier;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;

final class Notification
implements JsonStream.Streamable {
    private Configuration config;
    private Collection<Error> errors;
    private Collection<File> errorFiles;

    /*
     * WARNING - void declaration
     */
    Notification(Configuration config) {
        void var1_1;
        this.config = var1_1;
        this.errors = new LinkedList<Error>();
        this.errorFiles = new LinkedList<File>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void toStream(JsonStream writer) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("apiKey").value(this.config.apiKey);
        JsonStream.Streamable streamable = Notifier.getInstance();
        JsonStream jsonStream = writer.name("notifier");
        streamable.toStream(jsonStream);
        writer.name("events").beginArray();
        for (Error error : this.errors) {
            streamable = error;
            JsonStream jsonStream2 = writer;
            streamable.toStream(jsonStream2);
        }
        for (File file : this.errorFiles) {
            writer.value(file);
        }
        writer.endArray();
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    final void addError(Error error) {
        void var1_1;
        this.errors.add((Error)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void addError(File errorFile) {
        void var1_1;
        this.errorFiles.add((File)var1_1);
    }

    final int deliver() throws HttpClient$NetworkException, HttpClient$BadResponseException {
        Object object = this.config;
        Notification notification = this;
        object = ((Configuration)object).endpoint;
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2 = new URL((String)object);
            httpURLConnection = (HttpURLConnection)((URL)object2).openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setChunkedStreamingMode(0);
            httpURLConnection.addRequestProperty("Content-Type", "application/json");
            object2 = null;
            try {
                object2 = httpURLConnection.getOutputStream();
                JsonStream jsonStream = new JsonStream(new OutputStreamWriter((OutputStream)object2));
                notification.toStream(jsonStream);
                jsonStream.close();
            }
            finally {
                AppData.closeQuietly((Closeable)object2);
            }
            int n = httpURLConnection.getResponseCode();
            if (n / 100 != 2) {
                throw new HttpClient$BadResponseException((String)object, n);
            }
        }
        catch (IOException iOException) {
            try {
                throw new HttpClient$NetworkException((String)object, iOException);
            }
            catch (Throwable throwable) {
                AppData.close(httpURLConnection);
                throw throwable;
            }
        }
        AppData.close(httpURLConnection);
        return this.errors.size() + this.errorFiles.size();
    }
}

