/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.JsonStream;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

final class DeviceData
implements JsonStream.Streamable {
    private Context appContext;
    private float screenDensity;
    private float dpi;
    private String screenResolution;
    private long totalMemory;
    private boolean rooted;
    private String locale;
    private String id;
    private static final String[] ROOT_INDICATORS = new String[]{"/system/xbin/su", "/system/bin/su", "/system/app/Superuser.apk", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/SuperSU", "/system/xbin/daemonsu"};

    DeviceData(Context appContext) {
        String string;
        DisplayMetrics displayMetrics;
        Resources resources;
        this.appContext = appContext;
        Object object = resources = appContext.getResources();
        this.screenDensity = object == null ? 0.0f : object.getDisplayMetrics().density;
        object = resources;
        this.dpi = object == null ? 0.0f : (float)object.getDisplayMetrics().densityDpi;
        object = displayMetrics;
        if (object == null) {
            string = "";
        } else {
            displayMetrics = object.getDisplayMetrics();
            string = String.format("%dx%d", Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels), Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels));
        }
        this.screenResolution = string;
        this.totalMemory = Runtime.getRuntime().maxMemory() != Long.MAX_VALUE ? Runtime.getRuntime().maxMemory() : Runtime.getRuntime().totalMemory();
        this.rooted = DeviceData.isRooted();
        this.locale = Locale.getDefault().toString();
        object = this;
        displayMetrics = object.appContext.getContentResolver();
        this.id = Settings.Secure.getString((ContentResolver)displayMetrics, (String)"android_id");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void toStream(JsonStream writer) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("manufacturer").value(Build.MANUFACTURER);
        writer.name("brand").value(Build.BRAND);
        writer.name("model").value(Build.MODEL);
        writer.name("screenDensity").value(this.screenDensity);
        writer.name("dpi").value(this.dpi);
        writer.name("screenResolution").value(this.screenResolution);
        writer.name("totalMemory").value(this.totalMemory);
        writer.name("osName").value("android");
        writer.name("osBuild").value(Build.DISPLAY);
        writer.name("apiLevel").value(Build.VERSION.SDK_INT);
        writer.name("jailbroken").value(this.rooted);
        writer.name("locale").value(this.locale);
        writer.name("osVersion").value(Build.VERSION.RELEASE);
        writer.name("id").value(this.id);
        var1_1.endObject();
    }

    public final String getUserId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isRooted() {
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        try {
            String[] stringArray = ROOT_INDICATORS;
            for (int i = 0; i < 7; ++i) {
                void var2_2;
                String candidate = stringArray[i];
                if (!new File((String)var2_2).exists()) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

