/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

final class JsonWriter
implements Closeable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private final List<JsonScope> stack = new ArrayList<JsonScope>();
    private String separator;
    private String deferredName;
    private boolean serializeNulls;

    /*
     * WARNING - void declaration
     */
    public JsonWriter(Writer out) {
        void var1_1;
        this.stack.add(JsonScope.EMPTY_DOCUMENT);
        this.separator = ":";
        this.serializeNulls = true;
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        this.out = var1_1;
    }

    public final JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(JsonScope.EMPTY_ARRAY, "[");
    }

    public final JsonWriter endArray() throws IOException {
        return this.close(JsonScope.EMPTY_ARRAY, JsonScope.NONEMPTY_ARRAY, "]");
    }

    public final JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(JsonScope.EMPTY_OBJECT, "{");
    }

    public final JsonWriter endObject() throws IOException {
        return this.close(JsonScope.EMPTY_OBJECT, JsonScope.NONEMPTY_OBJECT, "}");
    }

    /*
     * WARNING - void declaration
     */
    private JsonWriter open(JsonScope empty, String openBracket) throws IOException {
        void var2_2;
        void var1_1;
        this.beforeValue(true);
        this.stack.add((JsonScope)var1_1);
        this.out.write((String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private JsonWriter close(JsonScope empty, JsonScope nonempty, String closeBracket) throws IOException {
        void var3_3;
        void var2_2;
        JsonWriter jsonWriter;
        JsonScope context = this.peek();
        if (context != nonempty && context != jsonWriter) {
            throw new IllegalStateException("Nesting problem: " + this.stack);
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        this.stack.remove(this.stack.size() - 1);
        if (context == var2_2) {
            jsonWriter = this;
        }
        this.out.write((String)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private JsonScope peek() {
        void var1_1;
        int size = this.stack.size();
        if (size == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack.get((int)(var1_1 - true));
    }

    /*
     * WARNING - void declaration
     */
    private void replaceTop(JsonScope topOfStack) {
        void var1_1;
        this.stack.set(this.stack.size() - 1, (JsonScope)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final JsonWriter name(String name) throws IOException {
        void var1_1;
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = var1_1;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            JsonWriter jsonWriter = this;
            Object object = jsonWriter.peek();
            if (object == JsonScope.NONEMPTY_OBJECT) {
                jsonWriter.out.write(44);
            } else if (object != JsonScope.EMPTY_OBJECT) {
                throw new IllegalStateException("Nesting problem: " + jsonWriter.stack);
            }
            object = jsonWriter;
            jsonWriter.replaceTop(JsonScope.DANGLING_NAME);
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final JsonWriter value(String value) throws IOException {
        void var1_1;
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.string((String)var1_1);
        return this;
    }

    public final JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue(false);
        this.out.write("null");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final JsonWriter value(boolean value) throws IOException {
        void var1_1;
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write(var1_1 != false ? "true" : "false");
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final JsonWriter value(Number value) throws IOException {
        void var2_2;
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value.toString();
        if (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN")) {
            void var1_1;
            throw new IllegalArgumentException("Numeric values must be finite, but was " + var1_1);
        }
        this.beforeValue(false);
        this.out.append((CharSequence)var2_2);
        return this;
    }

    public final void flush() throws IOException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() throws IOException {
        void var1_1;
        this.out.close();
        int size = this.stack.size();
        if (size > 1 || size == 1 && this.stack.get((int)(var1_1 - true)) != JsonScope.NONEMPTY_DOCUMENT) {
            throw new IOException("Incomplete document");
        }
        this.stack.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void string(String value) throws IOException {
        String[] replacements = REPLACEMENT_CHARS;
        this.out.write("\"");
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            void replacement22;
            String replacement22;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement22 = replacements[c];
                if (replacement22 == null) {
                    continue;
                }
            } else if (replacement22 == 8232) {
                replacement22 = "\\u2028";
            } else {
                if (replacement22 != 8233) continue;
                replacement22 = "\\u2029";
            }
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement22);
            last = i + 1;
        }
        if (last < length) {
            void var3_3;
            void var1_1;
            this.out.write((String)var1_1, last, length - var3_3);
        }
        this.out.write("\"");
    }

    /*
     * WARNING - void declaration
     */
    private void beforeValue(boolean root) throws IOException {
        switch (this.peek()) {
            case NONEMPTY_DOCUMENT: {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            case EMPTY_DOCUMENT: {
                void var1_1;
                if (var1_1 == false) {
                    throw new IllegalStateException("JSON must start with an array or an object.");
                }
                this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
                return;
            }
            case EMPTY_ARRAY: {
                this.replaceTop(JsonScope.NONEMPTY_ARRAY);
                JsonWriter jsonWriter = this;
                return;
            }
            case NONEMPTY_ARRAY: {
                this.out.append(',');
                JsonWriter jsonWriter = this;
                return;
            }
            case DANGLING_NAME: {
                this.out.append(this.separator);
                this.replaceTop(JsonScope.NONEMPTY_OBJECT);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem: " + this.stack);
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        String[] stringArray = (String[])REPLACEMENT_CHARS.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }

    static enum JsonScope {
        EMPTY_ARRAY,
        NONEMPTY_ARRAY,
        EMPTY_OBJECT,
        DANGLING_NAME,
        NONEMPTY_OBJECT,
        EMPTY_DOCUMENT,
        NONEMPTY_DOCUMENT,
        CLOSED;

    }
}

