/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.util.Log;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;

class AppData
implements JsonStream.Streamable {
    private Configuration config;
    private Context appContext;
    private String packageName;
    private String appName;
    private Integer versionCode;
    private String versionName;
    private String guessedReleaseStage;

    /*
     * WARNING - void declaration
     */
    AppData(Context appContext, Configuration config) {
        AppData appData;
        void var2_2;
        this.config = var2_2;
        this.appContext = appData;
        appData = this;
        this.packageName = appData.appContext.getPackageName();
        this.appName = this.getAppName();
        this.versionCode = this.getVersionCode();
        this.versionName = this.getVersionName();
        this.guessedReleaseStage = this.guessReleaseStage();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void toStream(JsonStream writer) {
        void var1_1;
        writer.beginObject();
        writer.name("id").value(this.packageName);
        writer.name("name").value(this.appName);
        writer.name("packageName").value(this.packageName);
        writer.name("versionName").value(this.versionName);
        writer.name("versionCode").value(this.versionCode);
        AppData appData = this;
        writer.name("version").value(appData.config.appVersion != null ? appData.config.appVersion : appData.versionName);
        writer.name("releaseStage").value(this.getReleaseStage());
        var1_1.endObject();
    }

    public final String getReleaseStage() {
        if (this.config.releaseStage != null) {
            return this.config.releaseStage;
        }
        return this.guessedReleaseStage;
    }

    /*
     * WARNING - void declaration
     */
    private String getAppName() {
        try {
            void var2_2;
            void var1_1;
            PackageManager packageManager = this.appContext.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(this.packageName, 0);
            return (String)var1_1.getApplicationLabel((ApplicationInfo)var2_2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AppData.warn("Could not get app name");
            return null;
        }
    }

    private Integer getVersionCode() {
        try {
            return this.appContext.getPackageManager().getPackageInfo((String)this.packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AppData.warn("Could not get versionCode");
            return null;
        }
    }

    private String getVersionName() {
        try {
            return this.appContext.getPackageManager().getPackageInfo((String)this.packageName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AppData.warn("Could not get versionName");
            return null;
        }
    }

    private String guessReleaseStage() {
        try {
            int n = this.appContext.getPackageManager().getApplicationInfo((String)this.packageName, (int)0).flags;
            if ((n & 2) != 0) {
                return "development";
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            AppData.warn("Could not get releaseStage");
        }
        return "production";
    }

    static void run(Runnable task) {
        Runnable runnable;
        new AsyncTask<Void, Void, Void>(runnable){
            private /* synthetic */ Runnable val$task;
            {
                this.val$task = runnable;
            }
        }.execute((Object[])new Void[0]);
    }

    static void info(String message) {
        String string;
        Log.i((String)"Bugsnag", (String)string);
    }

    static void warn(String message) {
        String string;
        Log.w((String)"Bugsnag", (String)string);
    }

    /*
     * WARNING - void declaration
     */
    static void warn(String message, Throwable e) {
        void var1_1;
        String string;
        Log.w((String)"Bugsnag", (String)string, (Throwable)var1_1);
    }
}

