/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;

class Stacktrace
implements JsonStream.Streamable {
    Configuration config;
    StackTraceElement[] stacktrace;

    Stacktrace(Configuration config, StackTraceElement[] stacktrace) {
        this.config = config;
        this.stacktrace = stacktrace;
    }

    @Override
    public void toStream(JsonStream writer) {
        writer.beginArray();
        for (StackTraceElement el : this.stacktrace) {
            try {
                writer.beginObject();
                writer.name("method").value(el.getClassName() + "." + el.getMethodName());
                writer.name("file").value(el.getFileName() == null ? "Unknown" : el.getFileName());
                writer.name("lineNumber").value(el.getLineNumber());
                if (this.config.inProject(el.getClassName())) {
                    writer.name("inProject").value(true);
                }
                writer.endObject();
            }
            catch (Exception lineEx) {
                lineEx.printStackTrace(System.err);
            }
        }
        writer.endArray();
    }
}

