/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.JsonStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MetaData
implements JsonStream.Streamable {
    private static final String FILTERED_PLACEHOLDER = "[FILTERED]";
    private static final String OBJECT_PLACEHOLDER = "[OBJECT]";
    private String[] filters;
    private HashMap<String, Object> store;

    public MetaData() {
        this.store = new HashMap();
    }

    public MetaData(Map<String, Object> m) {
        this.store = new HashMap<String, Object>(m);
    }

    @Override
    public void toStream(JsonStream writer) {
        this.objectToStream(this.store, writer);
    }

    public void addToTab(String tabName, String key, Object value) {
        Map<String, Object> tab = this.getTab(tabName);
        if (value != null) {
            tab.put(key, value);
        } else {
            tab.remove(key);
        }
    }

    public void clearTab(String tabName) {
        this.store.remove(tabName);
    }

    Map<String, Object> getTab(String tabName) {
        HashMap tab = (HashMap)this.store.get(tabName);
        if (tab == null) {
            tab = new HashMap();
            this.store.put(tabName, tab);
        }
        return tab;
    }

    void setFilters(String ... filters) {
        this.filters = filters;
    }

    static MetaData merge(MetaData ... metaDataList) {
        ArrayList<HashMap<String, Object>> stores = new ArrayList<HashMap<String, Object>>();
        for (MetaData metaData : metaDataList) {
            if (metaData == null) continue;
            stores.add(metaData.store);
        }
        return new MetaData(MetaData.mergeMaps(stores.toArray(new Map[0])));
    }

    private static Map<String, Object> mergeMaps(Map<String, Object> ... maps) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map<String, Object> map : maps) {
            if (map == null) continue;
            HashSet allKeys = new HashSet(result.keySet());
            allKeys.addAll(map.keySet());
            for (String key : allKeys) {
                Object baseValue = result.get(key);
                Object overridesValue = map.get(key);
                if (overridesValue != null) {
                    if (baseValue != null && baseValue instanceof Map && overridesValue instanceof Map) {
                        result.put(key, MetaData.mergeMaps((Map)baseValue, (Map)overridesValue));
                        continue;
                    }
                    result.put(key, overridesValue);
                    continue;
                }
                result.put(key, baseValue);
            }
        }
        return result;
    }

    private void objectToStream(Object obj, JsonStream writer) {
        if (obj == null) {
            writer.nullValue();
        } else if (obj instanceof String) {
            writer.value((String)obj);
        } else if (obj instanceof Number) {
            writer.value((Number)obj);
        } else if (obj instanceof Boolean) {
            writer.value((Boolean)obj);
        } else if (obj instanceof Map) {
            writer.beginObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                Object keyObj = entry.getKey();
                if (!(keyObj instanceof String)) continue;
                String key = (String)keyObj;
                writer.name(key);
                if (this.shouldFilter(key)) {
                    writer.value(FILTERED_PLACEHOLDER);
                    continue;
                }
                this.objectToStream(entry.getValue(), writer);
            }
            writer.endObject();
        } else if (obj instanceof Collection) {
            writer.beginArray();
            for (Object entry : (Collection)obj) {
                this.objectToStream(entry, writer);
            }
            writer.endArray();
        } else if (obj.getClass().isArray()) {
            writer.beginArray();
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                this.objectToStream(Array.get(obj, i), writer);
            }
            writer.endArray();
        } else {
            writer.value(OBJECT_PLACEHOLDER);
        }
    }

    private boolean shouldFilter(String key) {
        if (this.filters == null || key == null) {
            return false;
        }
        for (String filter : this.filters) {
            if (!key.contains(filter)) continue;
            return true;
        }
        return false;
    }
}

