/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;

class JsonStream {
    private JsonWriter writer;
    private Writer out;

    JsonStream(Writer out) {
        this.writer = new JsonWriter(out);
        this.out = out;
    }

    JsonStream beginObject() {
        try {
            this.writer.beginObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream endObject() {
        try {
            this.writer.endObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream beginArray() {
        try {
            this.writer.beginArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream endArray() {
        try {
            this.writer.endArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream name(String name) {
        try {
            this.writer.name(name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream nullValue() {
        try {
            this.writer.nullValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream value(String val) {
        try {
            this.writer.value(val);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream value(Number val) {
        try {
            this.writer.value(val);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    JsonStream value(Boolean val) {
        try {
            this.writer.value(val);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    JsonStream value(Streamable streamable) {
        streamable.toStream(this);
        return this;
    }

    JsonStream value(File file) {
        try {
            this.writer.flush();
            FileReader input = new FileReader(file);
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                this.out.write(buffer, 0, n);
            }
            this.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    static interface Streamable {
        public void toStream(JsonStream var1);
    }
}

