/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import com.bugsnag.android.Async;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.HttpClient;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Notification;
import java.io.File;
import java.io.FileWriter;

class ErrorStore {
    private static final String UNSENT_ERROR_PATH = "/bugsnag-errors/";
    private Configuration config;
    private String path;

    ErrorStore(Configuration config, Context appContext) {
        this.config = config;
        try {
            this.path = appContext.getCacheDir().getAbsolutePath() + UNSENT_ERROR_PATH;
            File outFile = new File(this.path);
            outFile.mkdirs();
            if (!outFile.exists()) {
                Logger.warn("Could not prepare error storage directory");
                this.path = null;
            }
        }
        catch (Exception e) {
            Logger.warn("Could not prepare error storage directory", e);
            this.path = null;
        }
    }

    void flush() {
        if (this.path == null) {
            return;
        }
        Async.run(new Runnable(){

            @Override
            public void run() {
                File exceptionDir = new File(ErrorStore.this.path);
                if (!exceptionDir.exists() || !exceptionDir.isDirectory()) {
                    return;
                }
                File[] errorFiles = exceptionDir.listFiles();
                if (errorFiles.length > 0) {
                    Logger.info(String.format("Sending %d saved error(s) to Bugsnag", errorFiles.length));
                    for (File errorFile : errorFiles) {
                        try {
                            Notification notif = new Notification(ErrorStore.this.config);
                            notif.addError(errorFile);
                            notif.deliver();
                            Logger.info("Deleting sent error file " + errorFile.getName());
                            errorFile.delete();
                        }
                        catch (HttpClient.NetworkException e) {
                            Logger.warn("Could not send previously saved error(s) to Bugsnag, will try again later", e);
                        }
                        catch (Exception e) {
                            Logger.warn("Problem sending unsent error from disk", e);
                            errorFile.delete();
                        }
                    }
                }
            }
        });
    }

    void write(Error error) {
        if (this.path == null) {
            return;
        }
        String filename = String.format("%s%d.json", this.path, System.currentTimeMillis());
        try {
            FileWriter out = new FileWriter(filename);
            new JsonStream(out).value(error).close();
            Logger.info(String.format("Saved unsent error to disk (%s) ", filename));
        }
        catch (Exception e) {
            Logger.warn(String.format("Couldn't save unsent error to disk (%s) ", filename), e);
        }
    }
}

