/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;

class DeviceState
implements JsonStream.Streamable {
    private Context appContext;
    private Long freeMemory;
    private String orientation;
    private Float batteryLevel;
    private Long freeDisk;
    private Boolean charging;
    private String locationStatus;
    private String networkAccess;

    DeviceState(Context appContext) {
        this.appContext = appContext;
        this.freeMemory = this.getFreeMemory();
        this.orientation = this.getOrientation();
        this.batteryLevel = this.getBatteryLevel();
        this.freeDisk = this.getFreeDisk();
        this.charging = this.isCharging();
        this.locationStatus = this.getLocationStatus();
        this.networkAccess = this.getNetworkAccess();
    }

    @Override
    public void toStream(JsonStream writer) {
        writer.beginObject();
        writer.name("freeMemory").value(this.freeMemory);
        writer.name("orientation").value(this.orientation);
        writer.name("batteryLevel").value(this.batteryLevel);
        writer.name("freeDisk").value(this.freeDisk);
        writer.name("charging").value(this.charging);
        writer.name("locationStatus").value(this.locationStatus);
        writer.name("networkAccess").value(this.networkAccess);
        writer.endObject();
    }

    private long getFreeMemory() {
        if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
            return Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        }
        return Runtime.getRuntime().freeMemory();
    }

    private String getOrientation() {
        String orientation = null;
        switch (this.appContext.getResources().getConfiguration().orientation) {
            case 2: {
                orientation = "landscape";
            }
            case 1: {
                orientation = "portrait";
            }
        }
        return orientation;
    }

    private Float getBatteryLevel() {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.appContext.registerReceiver(null, ifilter);
            return Float.valueOf((float)batteryStatus.getIntExtra("level", -1) / (float)batteryStatus.getIntExtra("scale", -1));
        }
        catch (Exception e) {
            Logger.warn("Could not get batteryLevel");
            return null;
        }
    }

    private Long getFreeDisk() {
        try {
            StatFs externalStat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long externalBytesAvailable = (long)externalStat.getBlockSize() * (long)externalStat.getBlockCount();
            StatFs internalStat = new StatFs(Environment.getDataDirectory().getPath());
            long internalBytesAvailable = (long)internalStat.getBlockSize() * (long)internalStat.getBlockCount();
            return Math.min(internalBytesAvailable, externalBytesAvailable);
        }
        catch (Exception e) {
            Logger.warn("Could not get freeDisk");
            return null;
        }
    }

    private Boolean isCharging() {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.appContext.registerReceiver(null, ifilter);
            int status = batteryStatus.getIntExtra("status", -1);
            return status == 2 || status == 5;
        }
        catch (Exception e) {
            Logger.warn("Could not get charging status");
            return null;
        }
    }

    private String getLocationStatus() {
        try {
            ContentResolver cr = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed != null && providersAllowed.length() > 0) {
                return "allowed";
            }
            return "disallowed";
        }
        catch (Exception e) {
            Logger.warn("Could not get locationStatus");
            return null;
        }
    }

    private String getNetworkAccess() {
        try {
            ConnectivityManager cm = (ConnectivityManager)this.appContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork != null && activeNetwork.isConnectedOrConnecting()) {
                if (activeNetwork.getType() == 1) {
                    return "wifi";
                }
                if (activeNetwork.getType() == 9) {
                    return "ethernet";
                }
                return "cellular";
            }
            return "none";
        }
        catch (Exception e) {
            Logger.warn("Could not get network access information, we recommend granting the 'android.permission.ACCESS_NETWORK_STATE' permission");
            return null;
        }
    }
}

