/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;

class AppData
implements JsonStream.Streamable {
    private Configuration config;
    private Context appContext;
    private String packageName;
    private String appName;
    private Integer versionCode;
    private String versionName;
    private String guessedReleaseStage;

    AppData(Context appContext, Configuration config) {
        this.config = config;
        this.appContext = appContext;
        this.packageName = this.getPackageName();
        this.appName = this.getAppName();
        this.versionCode = this.getVersionCode();
        this.versionName = this.getVersionName();
        this.guessedReleaseStage = this.guessReleaseStage();
    }

    @Override
    public void toStream(JsonStream writer) {
        writer.beginObject();
        writer.name("id").value(this.packageName);
        writer.name("name").value(this.appName);
        writer.name("packageName").value(this.packageName);
        writer.name("versionName").value(this.versionName);
        writer.name("versionCode").value(this.versionCode);
        writer.name("version").value(this.getAppVersion());
        writer.name("releaseStage").value(this.getReleaseStage());
        writer.endObject();
    }

    public String getReleaseStage() {
        if (this.config.releaseStage != null) {
            return this.config.releaseStage;
        }
        return this.guessedReleaseStage;
    }

    public String getAppVersion() {
        if (this.config.appVersion != null) {
            return this.config.appVersion;
        }
        return this.versionName;
    }

    private String getPackageName() {
        return this.appContext.getPackageName();
    }

    private String getAppName() {
        try {
            PackageManager packageManager = this.appContext.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(this.packageName, 0);
            return (String)packageManager.getApplicationLabel(appInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get app name");
            return null;
        }
    }

    private Integer getVersionCode() {
        try {
            return this.appContext.getPackageManager().getPackageInfo((String)this.packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get versionCode");
            return null;
        }
    }

    private String getVersionName() {
        try {
            return this.appContext.getPackageManager().getPackageInfo((String)this.packageName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get versionName");
            return null;
        }
    }

    private String guessReleaseStage() {
        try {
            int appFlags = this.appContext.getPackageManager().getApplicationInfo((String)this.packageName, (int)0).flags;
            if ((appFlags & 2) != 0) {
                return "development";
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get releaseStage");
        }
        return "production";
    }
}

