/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import com.bugsnag.android.AppData;
import com.bugsnag.android.AppState;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceState;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorStore;
import com.bugsnag.android.ExceptionHandler;
import com.bugsnag.android.HttpClient$BadResponseException;
import com.bugsnag.android.HttpClient$NetworkException;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Notification;
import com.bugsnag.android.Severity;
import com.bugsnag.android.User;
import java.util.Arrays;

public class Client {
    private Configuration config;
    private Context appContext;
    private AppData appData;
    private DeviceData deviceData;
    private User user = new User();
    private ErrorStore errorStore;

    /*
     * WARNING - void declaration
     */
    public Client(Context androidContext, String apiKey) {
        this((Context)var1_1, (String)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Client(Context androidContext, String apiKey, boolean enableExceptionHandler) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (androidContext == null) {
            throw new NullPointerException("You must provide a non-null android Context");
        }
        if (apiKey == null) {
            throw new NullPointerException("You must provide a Bugsnag API key");
        }
        this.config = new Configuration((String)var2_2);
        this.appContext = var1_1.getApplicationContext();
        this.appData = new AppData(this.appContext, this.config);
        this.deviceData = new DeviceData(this.appContext);
        AppState.init();
        this.setProjectPackages(this.appContext.getPackageName());
        this.setUserId(this.deviceData.getUserId());
        this.errorStore = new ErrorStore(this.config, this.appContext);
        if (var3_3 != false) {
            this.enableExceptionHandler();
        }
        this.errorStore.flush();
    }

    /*
     * WARNING - void declaration
     */
    public void setAppVersion(String appVersion) {
        void var1_1;
        this.config.appVersion = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(String context) {
        void var1_1;
        this.config.context = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEndpoint(String endpoint) {
        void var1_1;
        this.config.endpoint = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFilters(String ... filters) {
        void var1_1;
        this.config.filters = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoreClasses(String ... ignoreClasses) {
        void var1_1;
        this.config.ignoreClasses = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setNotifyReleaseStages(String ... notifyReleaseStages) {
        void var1_1;
        this.config.notifyReleaseStages = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setProjectPackages(String ... projectPackages) {
        void var1_1;
        this.config.projectPackages = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setReleaseStage(String releaseStage) {
        void var1_1;
        this.config.releaseStage = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSendThreads(boolean sendThreads) {
        void var1_1;
        this.config.sendThreads = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setUser(String id, String email, String name) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.user.setId((String)var1_1);
        this.user.setEmail((String)var2_2);
        this.user.setName((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserId(String id) {
        void var1_1;
        this.user.setId((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserEmail(String email) {
        void var1_1;
        this.user.setEmail((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserName(String name) {
        void var1_1;
        this.user.setName((String)var1_1);
    }

    public void beforeNotify(BeforeNotify beforeNotify) {
        Configuration configuration;
        void var2_2 = configuration;
        configuration = this.config;
        configuration.beforeNotifyTasks.add((BeforeNotify)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void notify(Throwable exception) {
        void var1_1;
        Error error = new Error(this.config, exception);
        this.notify((Error)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void notify(Throwable exception, Severity severity) {
        void var1_1;
        void var2_2;
        Error error = new Error(this.config, exception);
        error.setSeverity((Severity)var2_2);
        this.notify((Error)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void notify(Throwable exception, MetaData metaData) {
        void var1_1;
        void var2_2;
        Error error = new Error(this.config, exception);
        error.setMetaData((MetaData)var2_2);
        this.notify((Error)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void notify(Throwable exception, Severity severity, MetaData metaData) {
        void var1_1;
        void var3_3;
        void var2_2;
        Error error = new Error(this.config, exception);
        error.setSeverity((Severity)var2_2);
        error.setMetaData((MetaData)var3_3);
        this.notify((Error)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addToTab(String tab, String key, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.config.metaData.addToTab((String)var1_1, (String)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void clearTab(String tabName) {
        void var1_1;
        this.config.metaData.clearTab((String)var1_1);
    }

    public MetaData getMetaData() {
        return this.config.metaData;
    }

    /*
     * WARNING - void declaration
     */
    public void setMetaData(MetaData metaData) {
        void var1_1;
        this.config.metaData = var1_1;
    }

    public void enableExceptionHandler() {
        ExceptionHandler.enable(this);
    }

    public void disableExceptionHandler() {
        ExceptionHandler.disable(this);
    }

    /*
     * WARNING - void declaration
     */
    private void notify(Error error) {
        void var1_1;
        boolean bl;
        if (error.shouldIgnoreClass()) {
            return;
        }
        String string = this.appData.getReleaseStage();
        Object object = this.config;
        if (((Configuration)object).notifyReleaseStages == null) {
            bl = true;
        } else {
            object = Arrays.asList(((Configuration)object).notifyReleaseStages);
            bl = object.contains(string);
        }
        if (!bl) {
            return;
        }
        error.setAppData(this.appData);
        error.setDeviceData(this.deviceData);
        error.setAppState(new AppState(this.appContext));
        error.setDeviceState(new DeviceState(this.appContext));
        error.setUser(this.user);
        if (!this.runBeforeNotifyTasks(error)) {
            AppData.info("Skipping notification - beforeNotify task returned false");
            return;
        }
        Notification notification = new Notification(this.config);
        notification.addError(error);
        AppData.run(new Runnable(this, (Notification)object, (Error)var1_1){
            private /* synthetic */ Notification val$notification;
            private /* synthetic */ Error val$error;
            private /* synthetic */ Client this$0;
            {
                this.this$0 = client;
                this.val$notification = notification;
                this.val$error = error;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void run() {
                try {
                    int errorCount = this.val$notification.deliver();
                    AppData.info(String.format("Sent %d new error(s) to Bugsnag", errorCount));
                    return;
                }
                catch (HttpClient$NetworkException httpClient$NetworkException) {
                    AppData.info("Could not send error(s) to Bugsnag, saving to disk to send later");
                    this.this$0.errorStore.write(this.val$error);
                    return;
                }
                catch (HttpClient$BadResponseException httpClient$BadResponseException) {
                    AppData.info("Bad response when sending data to Bugsnag");
                    return;
                }
                catch (Exception e) {
                    void var1_2;
                    AppData.warn("Problem sending error to Bugsnag", (Throwable)var1_2);
                    return;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean runBeforeNotifyTasks(Error error) {
        for (BeforeNotify beforeNotify : this.config.beforeNotifyTasks) {
            try {
                if (beforeNotify.run(error)) continue;
                return false;
            }
            catch (Throwable ex) {
                void var3_4;
                AppData.warn("BeforeNotify threw an Exception", (Throwable)var3_4);
            }
        }
        return true;
    }
}

