/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import com.bugsnag.Error;
import com.bugsnag.MetaData;
import com.bugsnag.Metrics;
import com.bugsnag.Notification;
import com.bugsnag.android.ActivityStack;
import com.bugsnag.android.Diagnostics;
import com.bugsnag.android.Logger;
import com.bugsnag.android.utils.Async;
import com.bugsnag.http.BadResponseException;
import com.bugsnag.http.NetworkException;
import java.io.File;
import java.io.IOException;

public class Client
extends com.bugsnag.Client {
    private Logger logger = new Logger();
    private Context applicationContext;
    private String cachePath;

    public Client(Context object, String string, boolean bl) {
        super(string);
        this.setLogger(this.logger);
        this.applicationContext = object.getApplicationContext();
        this.diagnostics = new Diagnostics(this.config, this.applicationContext);
        this.cachePath = this.prepareCachePath();
        this.setNotifierName("Android Bugsnag Notifier");
        this.setNotifierVersion("2.2.0");
        if (bl) {
            object = this;
            Async.safeAsync(new Runnable((Client)((Object)object)){
                private /* synthetic */ Client this$0;
                {
                    this.this$0 = client;
                }

                @Override
                public final void run() {
                    try {
                        Metrics metrics = this.this$0.createMetrics();
                        metrics.deliver();
                        return;
                    }
                    catch (NetworkException networkException) {
                        this.this$0.logger.info("Could not send metrics to Bugsnag");
                        return;
                    }
                    catch (BadResponseException badResponseException) {
                        this.this$0.logger.warn(badResponseException.getMessage());
                        return;
                    }
                }
            });
        }
        object = this;
        if (object.cachePath != null) {
            Async.safeAsync(new Runnable((Client)((Object)object)){
                private /* synthetic */ Client this$0;
                {
                    this.this$0 = client;
                }

                @Override
                public final void run() {
                    File[] fileArray = new File(this.this$0.cachePath);
                    if (fileArray.exists() && fileArray.isDirectory()) {
                        Notification notification = null;
                        for (File file : fileArray.listFiles()) {
                            try {
                                if (notification == null) {
                                    notification = this.this$0.createNotification();
                                }
                                notification.setError(file);
                                notification.deliver();
                                this.this$0.logger.debug("Deleting sent error file " + file.getName());
                                file.delete();
                            }
                            catch (NetworkException networkException) {
                                this.this$0.logger.warn("Could not send error(s) to Bugsnag, will try again later", networkException);
                            }
                            catch (Exception exception) {
                                this.this$0.logger.warn("Problem sending unsent error from disk", exception);
                                file.delete();
                            }
                        }
                    }
                }
            });
        }
        this.logger.info("Bugsnag is loaded and ready to handle exceptions");
    }

    public void notify(Throwable throwable, String string, MetaData metaData) {
        try {
            if (!this.config.shouldNotify()) {
                return;
            }
            if (this.config.shouldIgnore(throwable.getClass().getName())) {
                return;
            }
            throwable = this.createError(throwable, string, metaData);
            Async.safeAsync(new Runnable(this, (Error)throwable){
                private /* synthetic */ Error val$error;
                private /* synthetic */ Client this$0;
                {
                    this.this$0 = client;
                    this.val$error = error;
                }

                @Override
                public final void run() {
                    try {
                        Notification notification = this.this$0.createNotification(this.val$error);
                        notification.deliver();
                        return;
                    }
                    catch (NetworkException networkException) {
                        this.this$0.logger.info("Could not send error(s) to Bugsnag, saving to disk to send later");
                        this.this$0.logger.info(networkException.toString());
                        Client.access$100(this.this$0, this.val$error);
                        return;
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            this.logger.warn("Error notifying Bugsnag", exception);
            return;
        }
    }

    public void setContext(Activity object) {
        object = ActivityStack.getContextName((Context)object);
        this.setContext((String)object);
    }

    public void setLogger(Logger logger) {
        super.setLogger((com.bugsnag.Logger)logger);
        Async.logger = logger;
    }

    private String prepareCachePath() {
        String string = null;
        try {
            string = this.applicationContext.getCacheDir().getAbsolutePath() + "/bugsnag-errors/";
            File file = new File(string);
            file.mkdirs();
            if (!file.exists()) {
                this.logger.warn("Could not prepare cache directory");
                string = null;
            }
        }
        catch (Exception exception) {
            this.logger.warn("Could not prepare cache directory", exception);
            string = null;
        }
        return string;
    }

    static /* synthetic */ void access$100(Client client, Error error) {
        if (client.cachePath == null || error == null) {
            return;
        }
        try {
            error.writeToFile(String.format("%s%d.json", client.cachePath, System.currentTimeMillis()));
            return;
        }
        catch (IOException iOException) {
            client.logger.warn("Unable to save bugsnag error", iOException);
            return;
        }
    }
}

