/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import android.os.SystemClock;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;

public class ActivityStack {
    private static List<WeakReference<Context>> storedContexts = new LinkedList<WeakReference<Context>>();
    private static WeakReference<Context> topContext;
    private static long sessionStartTime;
    private static long lastScreenClosed;
    private static boolean inForeground;

    public static void add(Activity activity) {
        ActivityStack.prune();
        storedContexts.add(new WeakReference<Activity>(activity));
    }

    public static void remove(Activity activity) {
        ActivityStack.prune();
        for (WeakReference<Context> weakReference : storedContexts) {
            if (weakReference.get() != activity) continue;
            storedContexts.remove(weakReference);
            return;
        }
    }

    public static List<String> getNames() {
        ActivityStack.prune();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (WeakReference<Context> weakReference : storedContexts) {
            if (weakReference.get() == null) continue;
            linkedList.add(ActivityStack.getContextName((Context)weakReference.get()));
        }
        return linkedList;
    }

    public static void setTopActivity(Activity activity) {
        topContext = new WeakReference<Activity>(activity);
        inForeground = true;
        if (lastScreenClosed + 10000L < SystemClock.elapsedRealtime()) {
            sessionStartTime = SystemClock.elapsedRealtime();
        }
    }

    public static void clearTopActivity() {
        topContext = null;
        inForeground = false;
        lastScreenClosed = SystemClock.elapsedRealtime();
    }

    public static String getTopActivityName() {
        String string = null;
        Context context = topContext != null ? (Context)topContext.get() : null;
        if (context != null) {
            string = ActivityStack.getContextName(context);
        }
        return string;
    }

    public static String getContextName(Context object) {
        object = object.getClass().getName();
        return ((String)object).substring(((String)object).lastIndexOf(46) + 1);
    }

    public static boolean inForeground() {
        return inForeground;
    }

    public static Long sessionLength() {
        if (inForeground) {
            return SystemClock.elapsedRealtime() - sessionStartTime;
        }
        return null;
    }

    private static void prune() {
        LinkedList<WeakReference<Context>> linkedList = new LinkedList<WeakReference<Context>>();
        for (WeakReference<Object> weakReference : storedContexts) {
            if (weakReference.get() != null) continue;
            linkedList.add(weakReference);
        }
        for (WeakReference<Object> weakReference : linkedList) {
            storedContexts.remove(weakReference);
        }
    }

    static {
        sessionStartTime = 0L;
        lastScreenClosed = 0L;
        inForeground = false;
    }
}

