/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;

public class ActivityStack {
    private static List<WeakReference<Context>> storedContexts = new LinkedList<WeakReference<Context>>();
    private static WeakReference<Context> topContext;

    public static void add(Activity activity) {
        ActivityStack.prune();
        storedContexts.add(new WeakReference<Activity>(activity));
    }

    public static List<String> getNames() {
        ActivityStack.prune();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (WeakReference<Context> weakReference : storedContexts) {
            if (weakReference.get() == null) continue;
            linkedList.add(ActivityStack.getContextName((Context)weakReference.get()));
        }
        return linkedList;
    }

    public static void setTopActivity(Activity activity) {
        topContext = new WeakReference<Activity>(activity);
    }

    public static Context getTopActivity() {
        if (topContext != null) {
            return (Context)topContext.get();
        }
        return null;
    }

    public static void clearTopActivity() {
        topContext = null;
    }

    public static String getTopActivityName() {
        String string = null;
        Context context = ActivityStack.getTopActivity();
        if (context != null) {
            string = ActivityStack.getContextName(context);
        }
        return string;
    }

    private static void prune() {
        LinkedList<WeakReference<Context>> linkedList = new LinkedList<WeakReference<Context>>();
        for (WeakReference<Object> weakReference : storedContexts) {
            if (weakReference.get() != null) continue;
            linkedList.add(weakReference);
        }
        for (WeakReference<Object> weakReference : linkedList) {
            storedContexts.remove(weakReference);
        }
    }

    public static String getContextName(Context object) {
        object = object.getClass().getName();
        return ((String)object).substring(((String)object).lastIndexOf(46) + 1);
    }
}

