/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.android.build.api.variant.VariantOutput;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.api.BaseVariantOutput;
import com.bugsnag.android.gradle.Abi;
import com.bugsnag.android.gradle.BugsnagGenerateUnitySoMappingTask;
import com.bugsnag.android.gradle.BugsnagPluginExtension;
import com.bugsnag.android.gradle.internal.AbstractSoMappingTask;
import com.bugsnag.android.gradle.internal.GradleUtilKt;
import com.bugsnag.android.gradle.internal.GradleUtilKt$sam$i$org_gradle_api_Action$0;
import com.bugsnag.android.gradle.internal.NdkToolchain;
import com.bugsnag.android.gradle.internal.VariantTaskCompanion;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0014R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001c\u0010\u000b\u001a\u00020\f8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/bugsnag/android/gradle/BugsnagGenerateUnitySoMappingTask;", "Lcom/bugsnag/android/gradle/internal/AbstractSoMappingTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "rootProjectDir", "Lorg/gradle/api/file/DirectoryProperty;", "getRootProjectDir", "()Lorg/gradle/api/file/DirectoryProperty;", "unitySharedObjectDir", "getUnitySharedObjectDir", "variantOutput", "Lcom/android/build/gradle/api/ApkVariantOutput;", "getVariantOutput$bugsnag_android_gradle_plugin", "()Lcom/android/build/gradle/api/ApkVariantOutput;", "setVariantOutput$bugsnag_android_gradle_plugin", "(Lcom/android/build/gradle/api/ApkVariantOutput;)V", "copySoFile", "Ljava/io/File;", "sharedObjectFile", "copyDir", "src", "Lokio/BufferedSource;", "copySoFilesFromBuildDir", "", "extractSoFilesFromZipArchive", "symbolArchives", "generateMappingFiles", "", "getUnitySymbolArchive", "projectDir", "getUnitySymbolArchives", "objdump", "Ljava/lang/ProcessBuilder;", "inputFile", "abi", "Lcom/bugsnag/android/gradle/Abi;", "Companion", "bugsnag-android-gradle-plugin"})
public abstract class BugsnagGenerateUnitySoMappingTask
extends AbstractSoMappingTask {
    public ApkVariantOutput variantOutput;
    @NotNull
    private final DirectoryProperty unitySharedObjectDir;
    @NotNull
    private final DirectoryProperty rootProjectDir;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Internal
    @NotNull
    public final ApkVariantOutput getVariantOutput$bugsnag_android_gradle_plugin() {
        ApkVariantOutput apkVariantOutput = this.variantOutput;
        if (apkVariantOutput == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantOutput");
        }
        return apkVariantOutput;
    }

    public final void setVariantOutput$bugsnag_android_gradle_plugin(@NotNull ApkVariantOutput apkVariantOutput) {
        Intrinsics.checkNotNullParameter((Object)apkVariantOutput, (String)"<set-?>");
        this.variantOutput = apkVariantOutput;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getUnitySharedObjectDir() {
        return this.unitySharedObjectDir;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getRootProjectDir() {
        return this.rootProjectDir;
    }

    @TaskAction
    public final void generateMappingFiles() {
        this.getLogger().lifecycle("Generating Unity mapping files");
        List<File> symbolArchives = this.getUnitySymbolArchives(this.rootProjectDir);
        File copyDir = (File)this.unitySharedObjectDir.getAsFile().get();
        File outputDir = (File)this.getOutputDirectory().getAsFile().get();
        File file = copyDir;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"copyDir");
        GradleUtilKt.clearDir(file);
        File file2 = outputDir;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"outputDir");
        GradleUtilKt.clearDir(file2);
        List sharedObjectFiles = CollectionsKt.toMutableList((Collection)this.copySoFilesFromBuildDir(copyDir));
        if (symbolArchives.isEmpty() && sharedObjectFiles.isEmpty()) {
            this.getLogger().warn("Bugsnag did not find any Unity SO files in Temp/StagingArea/symbols,or a symbols.zip. At least one of these options is required to fully symbolicate Unity stackframes. Please ensure that symbols.zip generation is enabled in build settings and that it hasn't been removed from the filesystem. See https://docs.unity3d.com/ScriptReference/EditorUserBuildSettings-androidCreateSymbolsZip.html");
            return;
        }
        sharedObjectFiles.addAll((Collection)this.extractSoFilesFromZipArchive(symbolArchives, copyDir));
        this.getLogger().info("Extracted Unity SO files: " + sharedObjectFiles);
        Iterable $this$forEach$iv = sharedObjectFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Abi abi;
            File sharedObjectFile = (File)element$iv;
            boolean bl = false;
            File file3 = sharedObjectFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"sharedObjectFile.parentFile");
            String string = file3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sharedObjectFile.parentFile.name");
            Intrinsics.checkNotNull((Object)((Object)Abi.Companion.findByName(string)));
            this.generateMappingFile(sharedObjectFile, abi);
        }
    }

    @Override
    @NotNull
    protected ProcessBuilder objdump(@NotNull File inputFile, @NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        String objdump = ((NdkToolchain)this.getNdkToolchain().get()).objdumpForAbi(abi).getPath();
        return new ProcessBuilder(objdump, "--sym", inputFile.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> extractSoFilesFromZipArchive(List<? extends File> symbolArchives, File copyDir) {
        void $this$flatMapTo$iv$iv;
        copyDir.mkdirs();
        Iterable $this$flatMap$iv = symbolArchives;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Enumeration<? extends ZipEntry> entries;
            File archive = (File)element$iv$iv;
            boolean bl = false;
            ZipFile zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> enumeration = entries = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries");
            Object object = enumeration;
            boolean bl2 = false;
            ArrayList<? extends ZipEntry> arrayList = Collections.list(object);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
            object = arrayList;
            boolean $i$f$filter = false;
            void var16_16 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ZipEntry it = (ZipEntry)element$iv$iv2;
                boolean bl3 = false;
                ZipEntry zipEntry = it;
                Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"it");
                String string = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (!Companion.isUnitySharedObjectFile$bugsnag_android_gradle_plugin(string)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File file;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                ZipEntry entry = (ZipEntry)element$iv$iv3;
                boolean bl5 = false;
                InputStream inputStream = zipFile.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"zipFile.getInputStream(entry)");
                BufferedSource src = Okio.buffer((Source)Okio.source((InputStream)inputStream));
                ZipEntry zipEntry = entry;
                Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"entry");
                if (this.copySoFile(new File(zipEntry.getName()), copyDir, src) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                File it$iv$iv = file;
                boolean bl8 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> copySoFilesFromBuildDir(File copyDir) {
        void $this$mapNotNullTo$iv$iv;
        Object object = this.rootProjectDir.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rootProjectDir.asFile.get()");
        File unityExportDir = ((File)object).getParentFile();
        File stagingAreaDir = new File(unityExportDir, "StagingArea");
        File unity2018LibDir = new File(stagingAreaDir, "symbols");
        List soFiles2 = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)unity2018LibDir)), (Function1)copySoFilesFromBuildDir.soFiles.1.INSTANCE));
        Iterable $this$mapNotNull$iv = soFiles2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File sharedObjectFile = (File)element$iv$iv;
            boolean bl2 = false;
            BufferedSource src = Okio.buffer((Source)Okio.source((File)sharedObjectFile));
            if (this.copySoFile(sharedObjectFile, copyDir, src) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            File it$iv$iv = file;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File copySoFile(File sharedObjectFile, File copyDir, BufferedSource src) {
        String string;
        String string2 = FilesKt.getExtension((File)sharedObjectFile);
        switch (string2.hashCode()) {
            case 3676: {
                if (string2.equals("so")) {
                    string = sharedObjectFile.getName();
                    break;
                }
            }
            default: {
                string = sharedObjectFile.getName() + ".so";
            }
        }
        String sharedObjectName = string;
        File file = sharedObjectFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"sharedObjectFile.parentFile");
        String arch = file.getName();
        ApkVariantOutput apkVariantOutput = this.variantOutput;
        if (apkVariantOutput == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantOutput");
        }
        String string3 = arch;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"arch");
        if (!GradleUtilKt.includesAbi(apkVariantOutput, string3)) {
            return null;
        }
        File archDir = new File(copyDir, arch);
        archDir.mkdir();
        File dst = new File(archDir, sharedObjectName);
        this.getLogger().info("Copying entry " + sharedObjectName + " to " + dst);
        Closeable closeable = (Closeable)src;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl3 = false;
            Sink sink = Okio.sink$default((File)dst, (boolean)false, (int)1, null);
            long l = it.readAll(sink);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dst;
    }

    private final List<File> getUnitySymbolArchives(DirectoryProperty rootProjectDir) {
        File unity2019ProjectDir;
        Object object = rootProjectDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rootProjectDir.get()");
        File file = unity2019ProjectDir = ((Directory)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"unity2019ProjectDir");
        File unity2018ProjectDir = file.getParentFile();
        boolean bl = false;
        List files = new ArrayList();
        files.addAll((Collection)this.getUnitySymbolArchive(unity2019ProjectDir));
        File file2 = unity2018ProjectDir;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"unity2018ProjectDir");
        files.addAll((Collection)this.getUnitySymbolArchive(file2));
        return files;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getUnitySymbolArchive(File projectDir) {
        List list;
        File exportDir = projectDir.getParentFile();
        File[] fileArray = exportDir.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_8 = $this$filterTo$iv$iv;
            int n = ((void)var8_8).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void file = element$iv$iv = var8_8[j];
                boolean bl = false;
                void v1 = file;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"file");
                String name = v1.getName();
                String projectName = projectDir.getName();
                String string = name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                String string2 = projectName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"projectName");
                if (!Companion.isUnitySymbolsArchive$bugsnag_android_gradle_plugin(string, string2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Inject
    public BugsnagGenerateUnitySoMappingTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.setGroup("Bugsnag");
        this.setDescription("Generates Unity mapping files for upload to Bugsnag");
        DirectoryProperty directoryProperty = objects.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.unitySharedObjectDir = directoryProperty;
        DirectoryProperty directoryProperty2 = objects.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"objects.directoryProperty()");
        this.rootProjectDir = directoryProperty2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0011J4\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/bugsnag/android/gradle/BugsnagGenerateUnitySoMappingTask$Companion;", "Lcom/bugsnag/android/gradle/internal/VariantTaskCompanion;", "Lcom/bugsnag/android/gradle/BugsnagGenerateUnitySoMappingTask;", "()V", "isUnityLibraryUploadEnabled", "", "bugsnag", "Lcom/bugsnag/android/gradle/BugsnagPluginExtension;", "android", "Lcom/android/build/gradle/BaseExtension;", "isUnityLibraryUploadEnabled$bugsnag_android_gradle_plugin", "isUnitySharedObjectFile", "name", "", "isUnitySharedObjectFile$bugsnag_android_gradle_plugin", "isUnitySymbolsArchive", "projectName", "isUnitySymbolsArchive$bugsnag_android_gradle_plugin", "register", "Lorg/gradle/api/tasks/TaskProvider;", "project", "Lorg/gradle/api/Project;", "output", "Lcom/android/build/gradle/api/ApkVariantOutput;", "ndk", "Lcom/bugsnag/android/gradle/internal/NdkToolchain;", "mappingFileOutputDir", "copyOutputDir", "taskNameFor", "variantOutputName", "bugsnag-android-gradle-plugin"})
    public static final class Companion
    implements VariantTaskCompanion<BugsnagGenerateUnitySoMappingTask> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<BugsnagGenerateUnitySoMappingTask> register(@NotNull Project project, @NotNull ApkVariantOutput output, @NotNull NdkToolchain ndk, @NotNull String mappingFileOutputDir, @NotNull String copyOutputDir) {
            void $this$register$iv$iv;
            void $this$register$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)ndk, (String)"ndk");
            Intrinsics.checkNotNullParameter((Object)mappingFileOutputDir, (String)"mappingFileOutputDir");
            Intrinsics.checkNotNullParameter((Object)copyOutputDir, (String)"copyOutputDir");
            VariantTaskCompanion variantTaskCompanion = this;
            Function1 configure$iv = (Function1)new Function1<BugsnagGenerateUnitySoMappingTask, Unit>(output, ndk, project, mappingFileOutputDir, copyOutputDir){
                final /* synthetic */ ApkVariantOutput $output;
                final /* synthetic */ NdkToolchain $ndk;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $mappingFileOutputDir;
                final /* synthetic */ String $copyOutputDir;

                public final void invoke(@NotNull BugsnagGenerateUnitySoMappingTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                    $this$register.setVariantOutput$bugsnag_android_gradle_plugin(this.$output);
                    $this$register.getNdkToolchain().set((Object)this.$ndk);
                    DirectoryProperty directoryProperty = $this$register.getRootProjectDir();
                    Project project = this.$project.getRootProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
                    directoryProperty.set(project.getProjectDir());
                    DirectoryProperty directoryProperty2 = $this$register.getOutputDirectory();
                    ProjectLayout projectLayout = this.$project.getLayout();
                    Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
                    directoryProperty2.set(projectLayout.getBuildDirectory().dir(this.$mappingFileOutputDir));
                    DirectoryProperty directoryProperty3 = $this$register.getUnitySharedObjectDir();
                    ProjectLayout projectLayout2 = this.$project.getLayout();
                    Intrinsics.checkNotNullExpressionValue((Object)projectLayout2, (String)"project.layout");
                    directoryProperty3.set(projectLayout2.getBuildDirectory().dir(this.$copyOutputDir));
                }
                {
                    this.$output = apkVariantOutput;
                    this.$ndk = ndkToolchain2;
                    this.$project = project;
                    this.$mappingFileOutputDir = string;
                    this.$copyOutputDir = string2;
                    super(1);
                }
            };
            boolean $i$f$register = false;
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskContainer taskContainer2 = taskContainer;
            String name$iv$iv = $this$register$iv.taskNameFor((BaseVariantOutput)output);
            boolean $i$f$register2 = false;
            Function1 function1 = configure$iv;
            TaskProvider taskProvider = $this$register$iv$iv.register(name$iv$iv, BugsnagGenerateUnitySoMappingTask.class, (Action)new GradleUtilKt$sam$i$org_gradle_api_Action$0(function1));
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.\u2026bjectType, configuration)");
            return taskProvider;
        }

        public final boolean isUnitySymbolsArchive$bugsnag_android_gradle_plugin(@NotNull String name, @NotNull String projectName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            return StringsKt.endsWith$default((String)name, (String)"symbols.zip", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)name, (String)projectName, (boolean)false, (int)2, null);
        }

        public final boolean isUnitySharedObjectFile$bugsnag_android_gradle_plugin(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            boolean extensionMatch = StringsKt.endsWith$default((String)name, (String)".sym.so", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".sym", (boolean)false, (int)2, null);
            boolean nameMatch = StringsKt.contains$default((CharSequence)name, (CharSequence)"libunity", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)"libil2cpp", (boolean)false, (int)2, null);
            return extensionMatch && nameMatch;
        }

        public final boolean isUnityLibraryUploadEnabled$bugsnag_android_gradle_plugin(@NotNull BugsnagPluginExtension bugsnag, @NotNull BaseExtension android) {
            Intrinsics.checkNotNullParameter((Object)bugsnag, (String)"bugsnag");
            Intrinsics.checkNotNullParameter((Object)android, (String)"android");
            Boolean enabled = (Boolean)bugsnag.getUploadNdkUnityLibraryMappings().getOrNull();
            if (enabled == null) {
                Companion companion = this;
                boolean bl = false;
                try {
                    Object object = Result.Companion;
                    Companion $this$runCatching = companion;
                    boolean bl2 = false;
                    Class<?> clz = android.getAaptOptions().getClass();
                    Method method = clz.getMethod("getNoCompress", new Class[0]);
                    Object noCompress = method.invoke((Object)android.getAaptOptions(), new Object[0]);
                    if (noCompress instanceof Collection) {
                        return ((Collection)noCompress).contains(".unity3d");
                    }
                    Unit unit = Unit.INSTANCE;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable) {
                    Result.Companion companion2 = Result.Companion;
                    boolean bl4 = false;
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return false;
            }
            return enabled;
        }

        @Override
        @NotNull
        public String taskNameFor(@NotNull String variantOutputName) {
            Intrinsics.checkNotNullParameter((Object)variantOutputName, (String)"variantOutputName");
            return "generateBugsnagUnity" + StringsKt.capitalize((String)variantOutputName) + "Mapping";
        }

        private Companion() {
        }

        @Override
        @NotNull
        public String taskNameFor(@NotNull BaseVariantOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return VariantTaskCompanion.DefaultImpls.taskNameFor(this, output);
        }

        @Override
        @NotNull
        public String taskNameFor(@NotNull VariantOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return VariantTaskCompanion.DefaultImpls.taskNameFor(this, output);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

