/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.bugsnag.android.gradle.AndroidManifestInfo;
import com.bugsnag.android.gradle.AndroidManifestParser;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00020\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0010\u001a\u00020\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/bugsnag/android/gradle/BugsnagManifestUuidTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "buildUuid", "Lorg/gradle/api/provider/Property;", "", "getBuildUuid", "()Lorg/gradle/api/provider/Property;", "inputManifest", "Lorg/gradle/api/file/RegularFileProperty;", "getInputManifest", "()Lorg/gradle/api/file/RegularFileProperty;", "manifestInfoProvider", "getManifestInfoProvider", "outputManifest", "getOutputManifest", "versionCode", "", "getVersionCode", "versionName", "getVersionName", "updateManifest", "", "writeManifestInfo", "info", "Lcom/bugsnag/android/gradle/AndroidManifestInfo;", "bugsnag-android-gradle-plugin"})
public abstract class BugsnagManifestUuidTask
extends DefaultTask {
    @NotNull
    private final Property<String> buildUuid;
    @NotNull
    private final RegularFileProperty manifestInfoProvider;
    @NotNull
    private final RegularFileProperty inputManifest;
    @NotNull
    private final RegularFileProperty outputManifest;
    @NotNull
    private final Property<Integer> versionCode;
    @NotNull
    private final Property<String> versionName;

    @Input
    @NotNull
    public final Property<String> getBuildUuid() {
        return this.buildUuid;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getManifestInfoProvider() {
        return this.manifestInfoProvider;
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public final RegularFileProperty getInputManifest() {
        return this.inputManifest;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getOutputManifest() {
        return this.outputManifest;
    }

    @Input
    @Optional
    @NotNull
    public final Property<Integer> getVersionCode() {
        return this.versionCode;
    }

    @Input
    @Optional
    @NotNull
    public final Property<String> getVersionName() {
        return this.versionName;
    }

    @TaskAction
    public final void updateManifest() {
        AndroidManifestParser manifestParser = new AndroidManifestParser();
        File output = (File)this.outputManifest.getAsFile().get();
        Object object = this.inputManifest.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputManifest.asFile.get()");
        File file = (File)object;
        Object object2 = this.outputManifest.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outputManifest.asFile.get()");
        File file2 = (File)object2;
        Object object3 = this.buildUuid.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"buildUuid.get()");
        manifestParser.writeBuildUuid(file, file2, (String)object3);
        File file3 = output;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"output");
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        this.writeManifestInfo(manifestParser.readManifest(file3, logger).withOverrides$bugsnag_android_gradle_plugin((Integer)this.versionCode.getOrNull(), (String)this.versionName.getOrNull()));
    }

    public final void writeManifestInfo(@NotNull AndroidManifestInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Object object = this.manifestInfoProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manifestInfoProvider.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"manifestInfoProvider.get().asFile");
        info.write$bugsnag_android_gradle_plugin(file);
    }

    @Inject
    public BugsnagManifestUuidTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.setGroup("Bugsnag");
        this.setDescription("Adds a unique build UUID to AndroidManifest to link proguard mappings to crash reports");
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        this.buildUuid = property;
        RegularFileProperty regularFileProperty = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.manifestInfoProvider = regularFileProperty;
        RegularFileProperty regularFileProperty2 = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"objects.fileProperty()");
        this.inputManifest = regularFileProperty2;
        RegularFileProperty regularFileProperty3 = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty3, (String)"objects.fileProperty()");
        this.outputManifest = regularFileProperty3;
        $this$property$iv = objects;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.javaObjectType)");
        this.versionCode = property2;
        $this$property$iv = objects;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.javaObjectType)");
        this.versionName = property3;
    }
}

