/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle.internal;

import com.bugsnag.android.gradle.internal.ProxyAuthenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0000\u00a8\u0006\u000e"}, d2={"configureHttpProxySettings", "", "builder", "Lokhttp3/OkHttpClient$Builder;", "newClient", "Lokhttp3/OkHttpClient;", "timeoutMillis", "", "runRequestWithRetries", "", "maxRetries", "", "request", "Lkotlin/Function0;", "bugsnag-android-gradle-plugin"})
public final class BugsnagHttpClientHelperKt {
    @NotNull
    public static final OkHttpClient newClient(long timeoutMillis) {
        Duration timeoutDuration = Duration.ofMillis(timeoutMillis);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Duration duration = timeoutDuration;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"timeoutDuration");
        OkHttpClient.Builder builder2 = builder.readTimeout(duration).writeTimeout(timeoutDuration).connectTimeout(timeoutDuration);
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ZERO");
        OkHttpClient.Builder builder3 = builder2.callTimeout(duration2);
        BugsnagHttpClientHelperKt.configureHttpProxySettings(builder3);
        return builder3.build();
    }

    private static final void configureHttpProxySettings(OkHttpClient.Builder builder) {
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host != null && port != null) {
            String string = port;
            boolean bl = false;
            InetSocketAddress socketAddress = new InetSocketAddress(host, Integer.parseInt(string));
            Proxy proxy = new Proxy(Proxy.Type.HTTP, socketAddress);
            builder.proxy(proxy);
        }
        String user = System.getProperty("http.proxyUser");
        String pass = System.getProperty("http.proxyPassword");
        if (user != null && pass != null) {
            java.net.Authenticator.setDefault(new ProxyAuthenticator(user, pass));
            builder.proxyAuthenticator(Authenticator.JAVA_NET_AUTHENTICATOR);
        }
    }

    @NotNull
    public static final String runRequestWithRetries(int maxRetries, @NotNull Function0<String> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        int attempts = 0;
        Throwable cause = null;
        while (true) {
            try {
                return (String)request.invoke();
            }
            catch (Throwable exc) {
                cause = exc;
                if (++attempts < maxRetries) continue;
                throw (Throwable)new IllegalStateException("Bugsnag request failed to complete", cause);
            }
            break;
        }
    }
}

