/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.bugsnag.android.gradle.AndroidManifestParser;
import com.bugsnag.android.gradle.BaseBugsnagManifestUuidTask;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\fH\u0002J \u0010'\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\fH\u0002J(\u0010(\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010*\u001a\u00020\u0012H\u0007R\u001c\u0010\u0005\u001a\u00020\u00068AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\f8AX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lcom/bugsnag/android/gradle/BugsnagManifestUuidTask;", "Lcom/bugsnag/android/gradle/BaseBugsnagManifestUuidTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "getVariant$bugsnag_android_gradle_plugin", "()Lcom/android/build/gradle/api/BaseVariant;", "setVariant$bugsnag_android_gradle_plugin", "(Lcom/android/build/gradle/api/BaseVariant;)V", "variantOutput", "Lcom/android/build/gradle/api/BaseVariantOutput;", "getVariantOutput$bugsnag_android_gradle_plugin", "()Lcom/android/build/gradle/api/BaseVariantOutput;", "setVariantOutput$bugsnag_android_gradle_plugin", "(Lcom/android/build/gradle/api/BaseVariantOutput;)V", "addManifestPath", "", "manifestPaths", "", "Ljava/io/File;", "directory", "logger", "Lorg/gradle/api/logging/Logger;", "findTaskNamesForPrefix", "", "", "output", "prefix", "findTaskNamesForPrefix$bugsnag_android_gradle_plugin", "getManifestOutputDir", "processManifest", "Lcom/android/build/gradle/tasks/ManifestProcessorTask;", "getManifestPaths", "project", "Lorg/gradle/api/Project;", "isRunningAssembleTask", "", "isRunningBundleTask", "isRunningTaskWithPrefix", "resolveBundleManifestOutputDirectory", "updateManifest", "Companion", "bugsnag-android-gradle-plugin"})
public class BugsnagManifestUuidTask
extends BaseBugsnagManifestUuidTask {
    @NotNull
    public BaseVariantOutput variantOutput;
    @NotNull
    public BaseVariant variant;
    private static final String ASSEMBLE_TASK = "assemble";
    private static final String BUNDLE_TASK = "bundle";
    public static final Companion Companion = new Companion(null);

    @Internal
    @NotNull
    public final BaseVariantOutput getVariantOutput$bugsnag_android_gradle_plugin() {
        BaseVariantOutput baseVariantOutput = this.variantOutput;
        if (baseVariantOutput == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantOutput");
        }
        return baseVariantOutput;
    }

    public final void setVariantOutput$bugsnag_android_gradle_plugin(@NotNull BaseVariantOutput baseVariantOutput) {
        Intrinsics.checkParameterIsNotNull((Object)baseVariantOutput, (String)"<set-?>");
        this.variantOutput = baseVariantOutput;
    }

    @Internal
    @NotNull
    public final BaseVariant getVariant$bugsnag_android_gradle_plugin() {
        BaseVariant baseVariant = this.variant;
        if (baseVariant == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variant");
        }
        return baseVariant;
    }

    public final void setVariant$bugsnag_android_gradle_plugin(@NotNull BaseVariant baseVariant) {
        Intrinsics.checkParameterIsNotNull((Object)baseVariant, (String)"<set-?>");
        this.variant = baseVariant;
    }

    @TaskAction
    public final void updateManifest() {
        File manifestPath;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        BaseVariant baseVariant = this.variant;
        if (baseVariant == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variant");
        }
        BaseVariantOutput baseVariantOutput = this.variantOutput;
        if (baseVariantOutput == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantOutput");
        }
        if ((manifestPath = this.getManifestPaths(project, baseVariant, baseVariantOutput)) == null) {
            Logger logger = this.getLogger();
            StringBuilder stringBuilder = new StringBuilder().append("Bugsnag: Failed to find manifest at ").append(manifestPath).append(" for ");
            BaseVariantOutput baseVariantOutput2 = this.variantOutput;
            if (baseVariantOutput2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"variantOutput");
            }
            logger.warn(stringBuilder.append(baseVariantOutput2).toString());
        }
        this.getLogger().info("Bugsnag: Updating manifest with build UUID: " + manifestPath);
        AndroidManifestParser manifestParser = new AndroidManifestParser();
        File file = manifestPath;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        Object object = this.getBuildUuid().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"buildUuid.get()");
        AndroidManifestParser.writeBuildUuid$default(manifestParser, file, null, (String)object, 2, null);
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        this.writeManifestInfo(manifestParser.readManifest(manifestPath, logger));
    }

    private final File getManifestPaths(Project project, BaseVariant variant, BaseVariantOutput variantOutput) {
        File directoryMerged = null;
        File directoryBundle = null;
        boolean bl = false;
        List manifestPaths = new ArrayList();
        boolean getMergedManifest = this.isRunningAssembleTask(project, variant, variantOutput);
        boolean getBundleManifest = this.isRunningBundleTask(project, variant, variantOutput);
        if (!getMergedManifest && !getBundleManifest) {
            getMergedManifest = true;
        }
        ManifestProcessorTask processManifest = (ManifestProcessorTask)variantOutput.getProcessManifestProvider().get();
        if (getMergedManifest) {
            ManifestProcessorTask manifestProcessorTask = processManifest;
            Intrinsics.checkExpressionValueIsNotNull((Object)manifestProcessorTask, (String)"processManifest");
            directoryMerged = this.getManifestOutputDir(manifestProcessorTask);
            if (directoryMerged != null) {
                Logger logger = this.getLogger();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
                this.addManifestPath(manifestPaths, directoryMerged, logger, variantOutput);
            }
        }
        if (getBundleManifest) {
            ManifestProcessorTask manifestProcessorTask = processManifest;
            Intrinsics.checkExpressionValueIsNotNull((Object)manifestProcessorTask, (String)"processManifest");
            directoryBundle = this.resolveBundleManifestOutputDirectory(manifestProcessorTask);
            Logger logger = this.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            this.addManifestPath(manifestPaths, directoryBundle, logger, variantOutput);
        }
        boolean bl2 = manifestPaths.size() == 1;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Unexpected number of manifest paths." + manifestPaths;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (File)manifestPaths.get(0);
    }

    private final void addManifestPath(List<File> manifestPaths, File directory, Logger logger, BaseVariantOutput variantOutput) {
        File manifestFile = Paths.get(directory.toString(), variantOutput.getDirName(), "AndroidManifest.xml").toFile();
        if (manifestFile.exists()) {
            logger.info("Bugsnag: Found manifest at " + manifestFile);
            manifestPaths.add(manifestFile);
        } else {
            logger.info("Bugsnag: Failed to find manifest at " + manifestFile);
        }
    }

    private final File getManifestOutputDir(ManifestProcessorTask processManifest) {
        File file;
        try {
            File file2;
            Object outputDir = processManifest.getClass().getMethod("getManifestOutputDirectory", new Class[0]).invoke((Object)processManifest, new Object[0]);
            if (outputDir instanceof File) {
                file2 = (File)outputDir;
            } else {
                Directory dir;
                Object object = outputDir;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.provider.Provider<org.gradle.api.file.Directory?>");
                }
                Directory directory = dir = (Directory)((Provider)object).getOrNull();
                file2 = directory != null ? directory.getAsFile() : null;
            }
            file = file2;
        }
        catch (Throwable exc) {
            this.getLogger().warn("Bugsnag: failed to find manifestOutputDir", exc);
            file = null;
        }
        return file;
    }

    private final File resolveBundleManifestOutputDirectory(ManifestProcessorTask processManifest) {
        File file;
        Method method = processManifest.getClass().getDeclaredMethod("getBundleManifestOutputDirectory", new Class[0]);
        Object directory = method.invoke((Object)processManifest, new Object[0]);
        if (directory instanceof File) {
            file = (File)directory;
        } else if (directory instanceof DirectoryProperty) {
            Object object = ((DirectoryProperty)directory).getAsFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"directory.asFile.get()");
            file = (File)object;
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return file;
    }

    private final boolean isRunningAssembleTask(Project project, BaseVariant variant, BaseVariantOutput output) {
        return this.isRunningTaskWithPrefix(project, variant, output, ASSEMBLE_TASK);
    }

    private final boolean isRunningBundleTask(Project project, BaseVariant variant, BaseVariantOutput output) {
        return this.isRunningTaskWithPrefix(project, variant, output, BUNDLE_TASK);
    }

    private final boolean isRunningTaskWithPrefix(Project project, BaseVariant variant, BaseVariantOutput output, String prefix) {
        boolean bl;
        block7: {
            HashSet taskNames = new HashSet();
            taskNames.addAll(this.findTaskNamesForPrefix$bugsnag_android_gradle_plugin(variant, output, prefix));
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
            Intrinsics.checkExpressionValueIsNotNull((Object)taskExecutionGraph, (String)"project.gradle.taskGraph");
            List list = taskExecutionGraph.getAllTasks();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"project.gradle.taskGraph.allTasks");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        Task task = (Task)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = taskNames;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl4 = false;
                                Task task2 = task;
                                Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"task");
                                String string = task2.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.name");
                                if (!StringsKt.endsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Set<String> findTaskNamesForPrefix$bugsnag_android_gradle_plugin(@NotNull BaseVariant variant, @NotNull BaseVariantOutput output, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        String string = output.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.name");
        String variantName = StringsKt.capitalize((String)((String)StringsKt.split$default((CharSequence)string, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null).get(0)));
        TaskProvider taskProvider = variant.getAssembleProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"variant.assembleProvider");
        Task assembleTask = (Task)taskProvider.getOrNull();
        HashSet<String> taskNames = new HashSet<String>();
        taskNames.add(prefix);
        if (assembleTask != null) {
            String assembleTaskName;
            String string2 = assembleTaskName = assembleTask.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"assembleTaskName");
            String buildTypeTaskName = StringsKt.replace$default((String)string2, (String)variantName, (String)"", (boolean)false, (int)4, null);
            String buildType = StringsKt.replace$default((String)buildTypeTaskName, (String)ASSEMBLE_TASK, (String)"", (boolean)false, (int)4, null);
            String variantTaskName = StringsKt.replace$default((String)assembleTaskName, (String)buildType, (String)"", (boolean)false, (int)4, null);
            taskNames.add(StringsKt.replace$default((String)assembleTaskName, (String)ASSEMBLE_TASK, (String)prefix, (boolean)false, (int)4, null));
            taskNames.add(StringsKt.replace$default((String)buildTypeTaskName, (String)ASSEMBLE_TASK, (String)prefix, (boolean)false, (int)4, null));
            taskNames.add(StringsKt.replace$default((String)variantTaskName, (String)ASSEMBLE_TASK, (String)prefix, (boolean)false, (int)4, null));
        }
        return taskNames;
    }

    @Inject
    public BugsnagManifestUuidTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        super(objects);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bugsnag/android/gradle/BugsnagManifestUuidTask$Companion;", "", "()V", "ASSEMBLE_TASK", "", "BUNDLE_TASK", "bugsnag-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

