/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.android.build.gradle.BaseExtension;
import com.bugsnag.android.gradle.Abi;
import com.bugsnag.android.gradle.SharedObjectMappingFileFactory$WhenMappings;
import com.bugsnag.android.gradle.internal.IOUtilKt;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J&\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a8\u0006 "}, d2={"Lcom/bugsnag/android/gradle/SharedObjectMappingFileFactory;", "", "()V", "calculateObjDumpLocation", "Ljava/io/File;", "ndkDir", "", "abi", "Lcom/bugsnag/android/gradle/Abi;", "osName", "calculateOsName", "findObjDump", "project", "Lorg/gradle/api/Project;", "arch", "generateSoMappingFile", "params", "Lcom/bugsnag/android/gradle/SharedObjectMappingFileFactory$Params;", "getObjDumpCommand", "Ljava/lang/ProcessBuilder;", "objDumpPath", "getObjDumpExecutable", "objDumpPaths", "", "getObjDumpOverride", "makeSoMappingFile", "", "dst", "processBuilder", "prepareArchDirectory", "Params", "SharedObjectType", "bugsnag-android-gradle-plugin"})
public final class SharedObjectMappingFileFactory {
    public static final SharedObjectMappingFileFactory INSTANCE;

    @Nullable
    public final File generateSoMappingFile(@NotNull Project project, @NotNull Params params) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        String arch = params.getAbi().getAbiName();
        File objDumpPath = this.getObjDumpExecutable(project, params.getObjDumpPaths(), arch);
        Logger logger = project.getLogger();
        if (objDumpPath == null) {
            logger.error("Bugsnag: Unable to upload NDK symbols: Could not find objdump location for " + arch);
            return null;
        }
        try {
            File archDir = this.prepareArchDirectory(params, arch);
            String sharedObjectName = params.getSharedObject().getName();
            File dst = new File(archDir, sharedObjectName + ".gz");
            ProcessBuilder processBuilder = this.getObjDumpCommand(objDumpPath, params);
            logger.info("Bugsnag: Creating symbol file for " + sharedObjectName + " at " + dst + ',' + "running " + processBuilder.command());
            this.makeSoMappingFile(dst, processBuilder);
            return dst;
        }
        catch (Exception e) {
            logger.error("Bugsnag: failed to generate symbols for " + arch + ' ' + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private final ProcessBuilder getObjDumpCommand(File objDumpPath, Params params) {
        ProcessBuilder processBuilder;
        String soPath = params.getSharedObject().getPath();
        String objdump = objDumpPath.getPath();
        switch (SharedObjectMappingFileFactory$WhenMappings.$EnumSwitchMapping$0[params.getSharedObjectType().ordinal()]) {
            case 1: {
                processBuilder = new ProcessBuilder(objdump, "--dwarf=info", "--dwarf=rawline", soPath);
                break;
            }
            case 2: {
                processBuilder = new ProcessBuilder(objdump, "--sym", soPath);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return processBuilder;
    }

    private final void makeSoMappingFile(File dst, ProcessBuilder processBuilder) {
        Process process;
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process2 = process = processBuilder.start();
        Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
        InputStream inputStream = process2.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
        IOUtilKt.outputZipFile(inputStream, dst);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw (Throwable)new IllegalStateException("Failed to generate symbols for " + dst + ',' + " objdump exited with code " + exitCode);
        }
    }

    private final File prepareArchDirectory(Params params, String arch) {
        File rootDir = params.getOutputDirectory();
        File file = new File(rootDir, arch);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.mkdir();
        return file;
    }

    private final File getObjDumpExecutable(Project project, Map<String, String> objDumpPaths, String arch) {
        try {
            File file;
            boolean bl;
            boolean bl2;
            String override = this.getObjDumpOverride(objDumpPaths, arch);
            File objDumpFile = null;
            String string = override;
            if (string != null) {
                String string2 = string;
                bl2 = false;
                bl = false;
                String it = string2;
                boolean bl3 = false;
                file = new File(it);
            } else {
                file = this.findObjDump(project, arch);
            }
            objDumpFile = file;
            boolean bl4 = objDumpFile.exists() && objDumpFile.canExecute();
            bl2 = false;
            bl = false;
            if (!bl4) {
                boolean bl5 = false;
                String string3 = "Failed to find executable objdump at " + objDumpFile;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            return objDumpFile;
        }
        catch (Throwable ex) {
            project.getLogger().error("Bugsnag: Error attempting to calculate objdump location: " + ex.getMessage());
            return null;
        }
    }

    private final String getObjDumpOverride(Map<String, String> objDumpPaths, String arch) {
        return objDumpPaths.get(arch);
    }

    private final File findObjDump(Project project, String arch) {
        Abi abi = Abi.Companion.findByName(arch);
        BaseExtension android = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
        String ndkDir = android.getNdkDirectory().getAbsolutePath();
        String osName = this.calculateOsName();
        boolean bl = false;
        boolean bl2 = false;
        if (abi == null) {
            boolean bl3 = false;
            String string = "Failed to find ABI for " + arch;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = false;
        bl2 = false;
        if (osName == null) {
            boolean bl4 = false;
            String string = "Failed to calculate OS name";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return SharedObjectMappingFileFactory.calculateObjDumpLocation(ndkDir, abi, osName);
    }

    @JvmStatic
    @NotNull
    public static final File calculateObjDumpLocation(@Nullable String ndkDir, @NotNull Abi abi, @NotNull String osName) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
        Intrinsics.checkParameterIsNotNull((Object)osName, (String)"osName");
        String executable = StringsKt.startsWith$default((String)osName, (String)"windows", (boolean)false, (int)2, null) ? "objdump.exe" : "objdump";
        return new File(ndkDir + "/toolchains/" + abi.getToolchainPrefix() + "-4.9/prebuilt/" + osName + "/bin/" + abi.getObjdumpPrefix() + '-' + executable);
    }

    private final String calculateOsName() {
        return Os.isFamily((String)"mac") ? "darwin-x86_64" : (Os.isFamily((String)"unix") ? "linux-x86_64" : (Os.isFamily((String)"windows") ? (Intrinsics.areEqual((Object)"x86", (Object)System.getProperty("os.arch")) ? "windows" : "windows-x86_64") : null));
    }

    private SharedObjectMappingFileFactory() {
    }

    static {
        SharedObjectMappingFileFactory sharedObjectMappingFileFactory;
        INSTANCE = sharedObjectMappingFileFactory = new SharedObjectMappingFileFactory();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/bugsnag/android/gradle/SharedObjectMappingFileFactory$SharedObjectType;", "", "(Ljava/lang/String;I)V", "NDK", "UNITY", "bugsnag-android-gradle-plugin"})
    public static final class SharedObjectType
    extends Enum<SharedObjectType> {
        public static final /* enum */ SharedObjectType NDK;
        public static final /* enum */ SharedObjectType UNITY;
        private static final /* synthetic */ SharedObjectType[] $VALUES;

        static {
            SharedObjectType[] sharedObjectTypeArray = new SharedObjectType[2];
            SharedObjectType[] sharedObjectTypeArray2 = sharedObjectTypeArray;
            sharedObjectTypeArray[0] = NDK = new SharedObjectType();
            sharedObjectTypeArray[1] = UNITY = new SharedObjectType();
            $VALUES = sharedObjectTypeArray;
        }

        public static SharedObjectType[] values() {
            return (SharedObjectType[])$VALUES.clone();
        }

        public static SharedObjectType valueOf(String string) {
            return Enum.valueOf(SharedObjectType.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/bugsnag/android/gradle/SharedObjectMappingFileFactory$Params;", "", "sharedObject", "Ljava/io/File;", "abi", "Lcom/bugsnag/android/gradle/Abi;", "objDumpPaths", "", "", "outputDirectory", "sharedObjectType", "Lcom/bugsnag/android/gradle/SharedObjectMappingFileFactory$SharedObjectType;", "(Ljava/io/File;Lcom/bugsnag/android/gradle/Abi;Ljava/util/Map;Ljava/io/File;Lcom/bugsnag/android/gradle/SharedObjectMappingFileFactory$SharedObjectType;)V", "getAbi", "()Lcom/bugsnag/android/gradle/Abi;", "getObjDumpPaths", "()Ljava/util/Map;", "getOutputDirectory", "()Ljava/io/File;", "getSharedObject", "getSharedObjectType", "()Lcom/bugsnag/android/gradle/SharedObjectMappingFileFactory$SharedObjectType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "bugsnag-android-gradle-plugin"})
    public static final class Params {
        @NotNull
        private final File sharedObject;
        @NotNull
        private final Abi abi;
        @NotNull
        private final Map<String, String> objDumpPaths;
        @NotNull
        private final File outputDirectory;
        @NotNull
        private final SharedObjectType sharedObjectType;

        @NotNull
        public final File getSharedObject() {
            return this.sharedObject;
        }

        @NotNull
        public final Abi getAbi() {
            return this.abi;
        }

        @NotNull
        public final Map<String, String> getObjDumpPaths() {
            return this.objDumpPaths;
        }

        @NotNull
        public final File getOutputDirectory() {
            return this.outputDirectory;
        }

        @NotNull
        public final SharedObjectType getSharedObjectType() {
            return this.sharedObjectType;
        }

        public Params(@NotNull File sharedObject, @NotNull Abi abi, @NotNull Map<String, String> objDumpPaths, @NotNull File outputDirectory, @NotNull SharedObjectType sharedObjectType) {
            Intrinsics.checkParameterIsNotNull((Object)sharedObject, (String)"sharedObject");
            Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
            Intrinsics.checkParameterIsNotNull(objDumpPaths, (String)"objDumpPaths");
            Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
            Intrinsics.checkParameterIsNotNull((Object)((Object)sharedObjectType), (String)"sharedObjectType");
            this.sharedObject = sharedObject;
            this.abi = abi;
            this.objDumpPaths = objDumpPaths;
            this.outputDirectory = outputDirectory;
            this.sharedObjectType = sharedObjectType;
        }

        public /* synthetic */ Params(File file, Abi abi, Map map, File file2, SharedObjectType sharedObjectType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                sharedObjectType = SharedObjectType.NDK;
            }
            this(file, abi, map, file2, sharedObjectType);
        }

        @NotNull
        public final File component1() {
            return this.sharedObject;
        }

        @NotNull
        public final Abi component2() {
            return this.abi;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.objDumpPaths;
        }

        @NotNull
        public final File component4() {
            return this.outputDirectory;
        }

        @NotNull
        public final SharedObjectType component5() {
            return this.sharedObjectType;
        }

        @NotNull
        public final Params copy(@NotNull File sharedObject, @NotNull Abi abi, @NotNull Map<String, String> objDumpPaths, @NotNull File outputDirectory, @NotNull SharedObjectType sharedObjectType) {
            Intrinsics.checkParameterIsNotNull((Object)sharedObject, (String)"sharedObject");
            Intrinsics.checkParameterIsNotNull((Object)((Object)abi), (String)"abi");
            Intrinsics.checkParameterIsNotNull(objDumpPaths, (String)"objDumpPaths");
            Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
            Intrinsics.checkParameterIsNotNull((Object)((Object)sharedObjectType), (String)"sharedObjectType");
            return new Params(sharedObject, abi, objDumpPaths, outputDirectory, sharedObjectType);
        }

        public static /* synthetic */ Params copy$default(Params params, File file, Abi abi, Map map, File file2, SharedObjectType sharedObjectType, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.sharedObject;
            }
            if ((n & 2) != 0) {
                abi = params.abi;
            }
            if ((n & 4) != 0) {
                map = params.objDumpPaths;
            }
            if ((n & 8) != 0) {
                file2 = params.outputDirectory;
            }
            if ((n & 0x10) != 0) {
                sharedObjectType = params.sharedObjectType;
            }
            return params.copy(file, abi, map, file2, sharedObjectType);
        }

        @NotNull
        public String toString() {
            return "Params(sharedObject=" + this.sharedObject + ", abi=" + (Object)((Object)this.abi) + ", objDumpPaths=" + this.objDumpPaths + ", outputDirectory=" + this.outputDirectory + ", sharedObjectType=" + (Object)((Object)this.sharedObjectType) + ")";
        }

        public int hashCode() {
            File file = this.sharedObject;
            Abi abi = this.abi;
            Map<String, String> map = this.objDumpPaths;
            File file2 = this.outputDirectory;
            SharedObjectType sharedObjectType = this.sharedObjectType;
            return ((((file != null ? ((Object)file).hashCode() : 0) * 31 + (abi != null ? ((Object)((Object)abi)).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (sharedObjectType != null ? ((Object)((Object)sharedObjectType)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.sharedObject, (Object)params.sharedObject) || !Intrinsics.areEqual((Object)((Object)this.abi), (Object)((Object)params.abi)) || !Intrinsics.areEqual(this.objDumpPaths, params.objDumpPaths) || !Intrinsics.areEqual((Object)this.outputDirectory, (Object)params.outputDirectory) || !Intrinsics.areEqual((Object)((Object)this.sharedObjectType), (Object)((Object)params.sharedObjectType))) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

