/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.UnknownConnectivity;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0015BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012>\u0010\u0004\u001a:\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\u0005j\u0004\u0018\u0001`\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/bugsnag/android/ConnectivityApi24;", "Lcom/bugsnag/android/Connectivity;", "cm", "Landroid/net/ConnectivityManager;", "callback", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "hasConnection", "", "networkState", "", "Lcom/bugsnag/android/NetworkChangeCallback;", "(Landroid/net/ConnectivityManager;Lkotlin/jvm/functions/Function2;)V", "networkCallback", "Lcom/bugsnag/android/ConnectivityApi24$ConnectivityTrackerCallback;", "hasNetworkConnection", "registerForNetworkChanges", "retrieveNetworkAccessState", "unregisterForNetworkChanges", "ConnectivityTrackerCallback", "bugsnag-android-core_release"})
@RequiresApi(value=24)
public final class ConnectivityApi24
implements Connectivity {
    @NotNull
    private final ConnectivityManager cm;
    @NotNull
    private final ConnectivityTrackerCallback networkCallback;

    public ConnectivityApi24(@NotNull ConnectivityManager cm, @Nullable Function2<? super Boolean, ? super String, Unit> callback) {
        this.cm = cm;
        this.networkCallback = new ConnectivityTrackerCallback(callback);
    }

    @Override
    public void registerForNetworkChanges() {
        this.cm.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    @Override
    public void unregisterForNetworkChanges() {
        this.cm.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    @Override
    public boolean hasNetworkConnection() {
        return this.cm.getActiveNetwork() != null;
    }

    @Override
    @NotNull
    public String retrieveNetworkAccessState() {
        Network network = this.cm.getActiveNetwork();
        NetworkCapabilities capabilities = network != null ? this.cm.getNetworkCapabilities(network) : null;
        return capabilities == null ? "none" : (capabilities.hasTransport(1) ? "wifi" : (capabilities.hasTransport(3) ? "ethernet" : (capabilities.hasTransport(0) ? "cellular" : "unknown")));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001BE\u0012>\u0010\u0002\u001a:\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016RF\u0010\u0002\u001a:\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/bugsnag/android/ConnectivityApi24$ConnectivityTrackerCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "cb", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "hasConnection", "", "networkState", "", "Lcom/bugsnag/android/NetworkChangeCallback;", "(Lkotlin/jvm/functions/Function2;)V", "receivedFirstCallback", "Ljava/util/concurrent/atomic/AtomicBoolean;", "invokeNetworkCallback", "onAvailable", "network", "Landroid/net/Network;", "onUnavailable", "bugsnag-android-core_release"})
    @VisibleForTesting
    public static final class ConnectivityTrackerCallback
    extends ConnectivityManager.NetworkCallback {
        @Nullable
        private final Function2<Boolean, String, Unit> cb;
        @NotNull
        private final AtomicBoolean receivedFirstCallback;

        public ConnectivityTrackerCallback(@Nullable Function2<? super Boolean, ? super String, Unit> cb) {
            this.cb = cb;
            this.receivedFirstCallback = new AtomicBoolean(false);
        }

        public void onUnavailable() {
            super.onUnavailable();
            this.invokeNetworkCallback(false);
        }

        public void onAvailable(@NotNull Network network) {
            super.onAvailable(network);
            this.invokeNetworkCallback(true);
        }

        private final void invokeNetworkCallback(boolean hasConnection) {
            Function2<Boolean, String, Unit> function2;
            if (this.receivedFirstCallback.getAndSet(true) && (function2 = this.cb) != null) {
                function2.invoke((Object)hasConnection, (Object)UnknownConnectivity.INSTANCE.retrieveNetworkAccessState());
            }
        }
    }
}

